/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.ShellException;
import org.ow2.petals.cli.shell.command.CommandException;
import org.ow2.petals.cli.shell.command.Deploy;
import org.ow2.petals.cli.shell.command.Exit;
import org.ow2.petals.cli.shell.command.Help;
import org.ow2.petals.cli.shell.command.ListArtefacts;
import org.ow2.petals.cli.shell.command.ListRegistry;
import org.ow2.petals.cli.shell.command.Load;
import org.ow2.petals.cli.shell.command.Print;
import org.ow2.petals.cli.shell.command.Pwd;
import org.ow2.petals.cli.shell.command.Set;
import org.ow2.petals.cli.shell.command.Show;
import org.ow2.petals.cli.shell.command.Shutdown;
import org.ow2.petals.cli.shell.command.Stop;
import org.ow2.petals.cli.shell.command.Undeploy;
import org.ow2.petals.cli.shell.command.Version;

public class PetalsShell
extends Shell {
    public static final Pattern REGEX_COMMENT = Pattern.compile("^\\s*(#.*)?$");
    public static final Pattern REGEX_VARIABLE = Pattern.compile("(\\\\|\\B)?(\\$\\{([-_\\.\\w]+)\\})");

    public PetalsShell() throws ShellException {
        this.register(new Exit(this));
        this.register(new Help(this));
        this.register(new Print(this));
        this.register(new Load(this));
        this.register(new Set(this));
        this.register(new Pwd(this));
        this.register(new ListArtefacts(this));
        this.register(new ListRegistry(this));
        this.register(new Deploy(this));
        this.register(new Undeploy(this));
        this.register(new Show(this));
        this.register(new Version(this));
        this.register(new Stop(this));
        this.register(new Shutdown(this));
    }

    public PetalsShell(String[] args) throws ShellException {
        this();
        try {
            this.evaluate(args);
        }
        catch (CommandException e) {
            throw new ShellException(e);
        }
    }

    @Override
    public String interpolate(String str) {
        Matcher m = REGEX_VARIABLE.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String backslash = m.group(1);
            String property = m.group(2).replace("$", "\\$");
            String name = m.group(3);
            String value = System.getProperty(name);
            if (value == null || backslash.length() > 0) {
                m.appendReplacement(sb, property);
                continue;
            }
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public boolean isComment(String line) {
        return REGEX_COMMENT.matcher(line).matches();
    }

    @Override
    public void exit(int status) {
        System.exit(status);
    }

    @Override
    public void evaluate(String[] args) throws ShellException, CommandException {
        try {
            super.evaluate(args);
            System.setProperty("status", "0");
        }
        catch (CommandException e) {
            System.setProperty("status", "1");
            throw e;
        }
    }
}

