/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.ow2.petals.cli.shell.ShellException;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandException;

public abstract class Shell {
    private Map<String, Command> commands;
    public final InputStream in = System.in;
    public final PrintStream out = System.out;
    public final PrintStream err = System.err;

    public Shell() {
        this.commands = new HashMap<String, Command>();
    }

    public Shell(Command[] commands) throws ShellException {
        this();
        for (Command c : commands) {
            this.register(c);
        }
    }

    public final Map<String, Command> getCommands() {
        return this.commands;
    }

    protected void register(Command command) throws ShellException {
        String name = command.getName();
        if (this.commands.containsKey(name)) {
            throw new ShellException("command '" + name + "' already registered");
        }
        this.commands.put(name, command);
    }

    public abstract boolean isComment(String var1);

    public abstract String interpolate(String var1);

    public abstract void exit(int var1);

    public void evaluate(String[] args) throws ShellException, CommandException {
        String[] nargs;
        Command cmd;
        assert (args != null && args.length > 0);
        if (this.commands.containsKey(args[0])) {
            cmd = this.commands.get(args[0]);
            nargs = new String[args.length - 1];
            for (int i = 0; i < nargs.length; ++i) {
                nargs[i] = this.interpolate(args[i + 1]);
            }
        } else {
            throw new ShellException(args[0] + ": unknown command");
        }
        cmd.execute(nargs);
    }

    public final void evaluate(String line) throws ShellException, CommandException {
        if (!this.isComment(line)) {
            StrMatcher delim = StrMatcher.splitMatcher();
            StrMatcher quote = StrMatcher.quoteMatcher();
            StrTokenizer tokenizer = new StrTokenizer(line, delim, quote);
            this.evaluate(tokenizer.getTokenArray());
        }
    }
}

