/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.Map;
import java.util.TreeMap;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandException;

public class Help
extends Command {
    public Help(Shell shell) {
        super(shell);
        this.setUsage("[command_name]");
        this.setDescription("Display this help message or help for a specific command");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        String message;
        this.checkArguments(args, 0, 1);
        if (args.length == 0) {
            message = this.getHelp();
        } else if (this.getShell().getCommands().containsKey(args[0])) {
            message = this.getHelpCommand(args[0]);
        } else {
            throw new CommandException(args[0] + ": unknown command");
        }
        this.getShell().out.println(message);
    }

    private String formatTitle(String title) {
        return String.format("%n%s:%n", title);
    }

    private String formatInfo(String info) {
        return String.format("   %s%n", info);
    }

    private String formatHelp(String name, String desc) {
        if (name.length() <= 8) {
            return String.format("   %-10s  %s.%n", name, desc);
        }
        return String.format("   %s%n               %s.%n", name, desc);
    }

    private String getHelp() {
        TreeMap<String, String> descs = new TreeMap<String, String>();
        for (Command cmd : this.getShell().getCommands().values()) {
            String name = cmd.getName();
            descs.put(name, cmd.getDescription());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.formatTitle("Available commands"));
        for (Map.Entry entry : descs.entrySet()) {
            buffer.append(this.formatHelp((String)entry.getKey(), (String)entry.getValue()));
        }
        buffer.append(this.formatTitle("For help on a specific command type"));
        buffer.append(this.formatInfo("help <command>"));
        return buffer.toString();
    }

    private String getHelpCommand(String name) {
        Command cmd = this.getShell().getCommands().get(name);
        String usage = cmd.getUsage();
        String description = cmd.getDescription();
        return String.format("%nusage: %s %s%n%n%s%n", name, usage, description);
    }
}

