/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.List;
import java.util.Map;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandException;
import org.ow2.petals.cli.shell.command.utils.JMXClientFactory;
import org.ow2.petals.jmx.JMXClient;

public class ListRegistry
extends Command {
    public ListRegistry(Shell shell) {
        super(shell);
        this.setUsage("");
        this.setDescription("List the entries of the registry");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            JMXClient client = JMXClientFactory.newInstance();
            List endpoints = client.getEndpointRegistryClient().getAllEndpoints();
            client.disconnect();
            for (Map endpoint : endpoints) {
                this.getShell().out.println("type : " + endpoint.get("type"));
                this.getShell().out.println("containerName : " + endpoint.get("containerName"));
                this.getShell().out.println("componentName : " + endpoint.get("componentName"));
                String[] interfaces = (String[])endpoint.get("interfaceNames");
                this.getShell().out.println("interfaceName : " + interfaces[0]);
                this.getShell().out.println("serviceName : " + endpoint.get("serviceName"));
                this.getShell().out.println("endpointName : " + endpoint.get("endpointName"));
                this.getShell().out.println();
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

