/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.jbi;

import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.w3c.dom.Node;

public abstract class Artifact {
    public static final String XPATH_JBI_ROOT = "/*[local-name()='jbi']";
    public static final String XPATH_JBI_NAME = "//*[local-name()='identification']/*[local-name()='name']";
    public static final String XPATH_JBI_DESCRIPTION = "//*[local-name()='identification']/*[local-name()='description']";
    private Node jbiConfig;
    private URL url;

    private Artifact() {
    }

    public Artifact(URL url, Node jbiConfig) {
        this();
        this.url = url;
        this.jbiConfig = jbiConfig;
    }

    public final URL getURL() {
        return this.url;
    }

    public final Node getJbiXml() {
        return this.jbiConfig;
    }

    public String getName() {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            String result = (String)xp.evaluate(XPATH_JBI_NAME, this.getJbiXml(), XPathConstants.STRING);
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPATH_JBI_NAME", e);
        }
    }

    public String getDescription() {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            String result = (String)xp.evaluate(XPATH_JBI_DESCRIPTION, this.getJbiXml(), XPathConstants.STRING);
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPATH_JBI_DESCRIPTION", e);
        }
    }

    public abstract AbstractJBIAntTask[] getDeployTasksSequence();

    public abstract AbstractJBIAntTask[] getUndeployTasksSequence();

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Name:          ").append(this.getName()).append(nl);
        sb.append("Description:   ").append(this.getDescription()).append(nl);
        sb.append("Type:          ").append(this.getClass().getSimpleName()).append(nl);
        sb.append("URL:           ").append(this.getURL().toString()).append(nl);
        return sb.toString();
    }
}

