/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.jbi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.cli.shell.jbi.Artifact;
import org.ow2.petals.cli.shell.jbi.ArtifactException;
import org.ow2.petals.cli.shell.jbi.BindingComponent;
import org.ow2.petals.cli.shell.jbi.ServiceAssembly;
import org.ow2.petals.cli.shell.jbi.ServiceEngine;
import org.ow2.petals.cli.shell.jbi.SharedLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class ArtifactFactory {
    public static final String JBI_XML_PATH = "META-INF/jbi.xml";
    public static final String XPATH_JBI_BC_TYPE = "/*[local-name()='jbi']/*[local-name()='component'][@type='binding-component']";
    public static final String XPATH_JBI_SL_TYPE = "/*[local-name()='jbi']/*[local-name()='shared-library']";
    public static final String XPATH_JBI_SA_TYPE = "/*[local-name()='jbi']/*[local-name()='service-assembly']";
    public static final String XPATH_JBI_SE_TYPE = "/*[local-name()='jbi']/*[local-name()='component'][@type='service-engine']";

    public static final Artifact newInstance(URL url) throws ArtifactException {
        try {
            File tmpfile = ArtifactFactory.copyURLToTempFile(url);
            Node jbi = ArtifactFactory.extractJbiXml(tmpfile);
            tmpfile.delete();
            XPath xpath = XPathFactory.newInstance().newXPath();
            if (((Boolean)xpath.evaluate(XPATH_JBI_BC_TYPE, jbi, XPathConstants.BOOLEAN)).booleanValue()) {
                return new BindingComponent(url, jbi);
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SL_TYPE, jbi, XPathConstants.BOOLEAN)).booleanValue()) {
                return new SharedLibrary(url, jbi);
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SA_TYPE, jbi, XPathConstants.BOOLEAN)).booleanValue()) {
                return new ServiceAssembly(url, jbi);
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SE_TYPE, jbi, XPathConstants.BOOLEAN)).booleanValue()) {
                return new ServiceEngine(url, jbi);
            }
            throw new ArtifactException(url.toString() + ": not a valid JBI archive");
        }
        catch (Exception e) {
            throw new ArtifactException(e);
        }
    }

    protected static Node extractJbiXml(File archive) throws ZipException, IOException, ParserConfigurationException, SAXException {
        ZipFile zipfile = new ZipFile(archive);
        ZipEntry jbixml = zipfile.getEntry(JBI_XML_PATH);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(zipfile.getInputStream(jbixml));
        doc.getDocumentElement().normalize();
        return doc;
    }

    protected static File copyURLToTempFile(URL url) throws IOException {
        File result = File.createTempFile("jbi", ".zip");
        result.deleteOnExit();
        FileUtils.copyURLToFile(url, result);
        return result;
    }
}

