/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.RouterMonitorServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.RouterMonitorServiceErrorException;

public class RouterMonitorServiceClient
extends AbstractServiceClient {
    private static final String ROUTER_MONITOR_JMX_NAME = "RouterMonitor";
    private static final String CLEAR_MONITOR_STORAGE = "clearMonitorStorage";
    private static final String GET_EXCHANGE_HISTORY = "getExchangeHistory";
    private static final String GET_EXCHANGE = "getExchange";
    private static final String GET_EXCHANGE_IDS = "getExchangeIds";
    private static final String GET_EXCHANGES = "getExchanges";
    private static final String MONITOR_EXCHANGES = "monitorExchanges";
    private static final String UNMONITOR_EXCHANGES = "unmonitorExchanges";
    private static final String GET_MONITORED_EXCHANGES = "getMonitoredExchanges";
    private static final String SET_MONITOR_STORAGE_DURATION = "setMonitorStorageDuration";
    private static final String GET_MONITOR_STORAGE_DURATION = "getMonitorStorageDuration";

    public RouterMonitorServiceClient(String petalsDomain, MBeanServerConnection mBeanServerConnection) throws RouterMonitorServiceDoesNotExistException, RouterMonitorServiceErrorException {
        super(petalsDomain, mBeanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", ROUTER_MONITOR_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new RouterMonitorServiceDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (IOException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
    }

    public void clearMonitorStorage() throws RouterMonitorServiceErrorException {
        try {
            this.performAction(CLEAR_MONITOR_STORAGE, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
    }

    public Map<String, String> getExchange(String exchangeId) throws RouterMonitorServiceErrorException {
        Map result;
        Object[] objects = new Object[]{exchangeId};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Map)this.performAction(GET_EXCHANGE, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public Map<String, Long> getExchangeHistory(String exchangeId) throws RouterMonitorServiceErrorException {
        Map result;
        Object[] objects = new Object[]{exchangeId};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Map)this.performAction(GET_EXCHANGE_HISTORY, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public List<String> getExchangeIds(QName interfaceName, QName serviceName, String endpointName, QName operationName, long startDate, long endDate) throws RouterMonitorServiceErrorException {
        List result;
        Object[] objects = new Object[]{interfaceName, serviceName, endpointName, operationName, startDate, endDate};
        String[] strings = new String[]{QName.class.getName(), QName.class.getName(), String.class.getName(), QName.class.getName(), Long.TYPE.getName(), Long.TYPE.getName()};
        try {
            result = (List)this.performAction(GET_EXCHANGE_IDS, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public List<String> getExchangeIds(String propertyKey, String propertyValue) throws RouterMonitorServiceErrorException {
        List result;
        Object[] objects = new Object[]{propertyKey, propertyValue};
        String[] strings = new String[]{String.class.getName(), String.class.getName()};
        try {
            result = (List)this.performAction(GET_EXCHANGE_IDS, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public int getExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName, long startDate, long endDate) throws RouterMonitorServiceErrorException {
        Integer result;
        Object[] objects = new Object[]{interfaceName, serviceName, endpointName, operationName, startDate, endDate};
        String[] strings = new String[]{QName.class.getName(), QName.class.getName(), String.class.getName(), QName.class.getName(), Long.TYPE.getName(), Long.TYPE.getName()};
        try {
            result = (Integer)this.performAction(GET_EXCHANGES, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public List<Map<String, String>> getMonitoredExchange() throws RouterMonitorServiceErrorException {
        List result;
        try {
            result = (List)this.performAction(GET_MONITORED_EXCHANGES, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public Long getMonitorStorageDuration() throws RouterMonitorServiceErrorException {
        Long result;
        try {
            result = (Long)this.performAction(GET_MONITOR_STORAGE_DURATION, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new RouterMonitorServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public void monitorExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName, boolean storeExchanges) throws RouterMonitorServiceErrorException {
        Object[] objects = new Object[]{interfaceName, serviceName, endpointName, operationName, storeExchanges};
        String[] strings = new String[]{QName.class.getName(), QName.class.getName(), String.class.getName(), QName.class.getName(), Boolean.TYPE.getName()};
        try {
            this.performAction(MONITOR_EXCHANGES, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
    }

    public void setMonitorStorageDuration(long duration) throws RouterMonitorServiceErrorException {
        Object[] objects = new Object[]{duration};
        String[] strings = new String[]{Long.TYPE.getName()};
        try {
            this.performAction(SET_MONITOR_STORAGE_DURATION, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
    }

    public void unmonitorExchanges(QName interfaceName, QName serviceName, String endpointName, QName operationName) throws RouterMonitorServiceErrorException {
        Object[] objects = new Object[]{interfaceName, serviceName, endpointName, operationName};
        String[] strings = new String[]{QName.class.getName(), QName.class.getName(), String.class.getName(), QName.class.getName()};
        try {
            this.performAction(UNMONITOR_EXCHANGES, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new RouterMonitorServiceErrorException(e);
        }
    }
}

