/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.ow2.petals.ant.AbstractConfigureArchiveAntTask;
import org.ow2.petals.ant.util.ZipUtil;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;

public class ConfigureComponentTask
extends AbstractConfigureArchiveAntTask {
    private String identification;
    private final List<SharedLibrary> sharedLibraries = new ArrayList<SharedLibrary>();
    private String slProperties;

    public SharedLibrary createSharedLibrary() {
        SharedLibrary sharedLibrary = new SharedLibrary();
        this.sharedLibraries.add(sharedLibrary);
        return sharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        super.execute();
        final ArrayList<_SharedLibrary> _sharedLibraries = new ArrayList<_SharedLibrary>();
        try {
            this.loadSharedLibrariesProperties();
            for (SharedLibrary sharedLibrary : this.sharedLibraries) {
                URL slUrl = ConfigureComponentTask.validateFileParameter(sharedLibrary.getFile(), "sharedlibrary.file");
                File slFile = ConfigureComponentTask.downloadURL(slUrl);
                try {
                    ZipFile slZip = new ZipFile(slFile);
                    try {
                        ZipEntry jbiZipEntry = slZip.getEntry("META-INF/jbi.xml");
                        InputStream jbiInputStream = slZip.getInputStream(jbiZipEntry);
                        try {
                            Jbi slJbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiInputStream);
                            _SharedLibrary _sharedLibrary = new _SharedLibrary();
                            _sharedLibrary.identification = slJbi.getSharedLibrary().getIdentification().getName();
                            _sharedLibrary.version = slJbi.getSharedLibrary().getVersion();
                            _sharedLibraries.add(_sharedLibrary);
                        }
                        finally {
                            jbiInputStream.close();
                        }
                    }
                    finally {
                        slZip.close();
                    }
                }
                finally {
                    slFile.delete();
                }
            }
            URL url = ConfigureComponentTask.validateFileParameter(this.file, "file");
            File componentFile = ConfigureComponentTask.downloadURL(url);
            try {
                ZipFile zipComponentFile = new ZipFile(componentFile);
                try {
                    ZipOutputStream zipOutputFile = new ZipOutputStream(new FileOutputStream(this.outputFile));
                    ZipUtil.copyAndUpdateZipFile(zipComponentFile, zipOutputFile, new ZipUtil.ZipEntryCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public InputStream onZipEntry(ZipEntry zipEntry, InputStream zipEntryInputStream) throws IOException, JBIDescriptorException {
                            if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                                ByteArrayInputStream resultStream = null;
                                try {
                                    Jbi componentJbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)zipEntryInputStream);
                                    List componentSLs = componentJbi.getComponent().getSharedLibraryList();
                                    componentSLs.clear();
                                    for (_SharedLibrary _sharedLibrary : _sharedLibraries) {
                                        Component.SharedLibrary sharedLibrary = new Component.SharedLibrary();
                                        sharedLibrary.setContent(_sharedLibrary.identification);
                                        sharedLibrary.setVersion(_sharedLibrary.version);
                                        componentSLs.add(sharedLibrary);
                                    }
                                    if (ConfigureComponentTask.this.identification != null) {
                                        componentJbi.getComponent().getIdentification().setName(ConfigureComponentTask.this.identification);
                                    }
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    JBIDescriptorBuilder.writeJBIdescriptor((Jbi)componentJbi, (OutputStream)baos);
                                    resultStream = new ByteArrayInputStream(baos.toByteArray());
                                }
                                finally {
                                    zipEntryInputStream.close();
                                }
                                return resultStream;
                            }
                            return zipEntryInputStream;
                        }
                    });
                    zipOutputFile.flush();
                    zipOutputFile.close();
                }
                finally {
                    zipComponentFile.close();
                }
            }
            finally {
                componentFile.delete();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (JBIDescriptorException e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Component configuration set");
    }

    public String getIdentification() {
        return this.identification;
    }

    public String getSlProperties() {
        return this.slProperties;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public void setSlProperties(String slProperties) {
        this.slProperties = slProperties;
    }

    private void loadSharedLibrariesProperties() throws IOException {
        Properties props = new Properties();
        if (this.slProperties != null) {
            props.load(new FileInputStream(this.slProperties));
        }
        for (Object value : props.values()) {
            SharedLibrary sl = new SharedLibrary((String)value);
            this.sharedLibraries.add(sl);
        }
    }

    private static final class _SharedLibrary {
        public String identification;
        public String version;

        private _SharedLibrary() {
        }
    }

    public static final class SharedLibrary {
        private String file;

        public SharedLibrary() {
        }

        public SharedLibrary(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

