/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractInstallerAntTask;
import org.ow2.petals.ant.task.primitive.PrimitiveConverter;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterBoolean;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterDouble;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterFloat;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterInteger;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterLong;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterShort;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;

public class InstallComponentTask
extends AbstractInstallerAntTask {
    private static final Map<String, PrimitiveConverter> primitiveClasses = new Hashtable<String, PrimitiveConverter>();
    private Set<MBeanAttributeInfo> configurationAttributes;
    private final List<Param> nestedParams = new ArrayList<Param>();
    private String params;

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    @Override
    public void doTask() throws Exception {
        URL fileURL = this.validateFileParameter();
        InstallerComponentClient installer = this.getJMXClient().getInstallationServiceClient().loadNewInstaller(fileURL);
        Properties propertiesParams = this.loadProperties();
        if (this.nestedParams.size() > 0 || propertiesParams.size() > 0) {
            this.log(this.nestedParams.size() + propertiesParams.size() + " installation parameters will be set to the installer");
            ConfigurationInstallerComponentClient installerConfigurationMBean = installer.getConfigurationInstallerClient();
            if (installerConfigurationMBean != null) {
                this.configurationAttributes = installerConfigurationMBean.getAttributes().keySet();
                this.setConnectionAttributeFromNestedParam(installerConfigurationMBean);
                this.setConnectionAttributeFromPropertiesFile(installerConfigurationMBean, propertiesParams);
            } else {
                this.log("No installer configuration MBean proposed by the installer MBean!", LogLevel.WARN.getLevel());
            }
        }
        installer.install();
        this.log("Component '" + installer.getMBeanName().getKeyProperty("name") + "' installed");
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        if (this.params != null) {
            props.load(new FileInputStream(this.params));
        }
        return props;
    }

    private void setAttribute(ConfigurationInstallerComponentClient installerConfigurationMBean, String key, String value) throws AttributeErrorException {
        Object castedValue = null;
        boolean found = false;
        for (MBeanAttributeInfo attributeInfo : this.configurationAttributes) {
            if (!attributeInfo.getName().equals(key)) continue;
            if (primitiveClasses.containsKey(attributeInfo.getType())) {
                PrimitiveConverter primitiveConverter = primitiveClasses.get(attributeInfo.getType());
                try {
                    castedValue = primitiveConverter.convert(value);
                }
                catch (BuildException e) {
                    throw new BuildException("Invalid value for attribute '" + key + "': " + e.getMessage());
                }
            } else if (attributeInfo.getType().equals(String.class.getName())) {
                castedValue = value;
            }
            found = true;
            break;
        }
        if (castedValue == null) {
            if (found) {
                throw new RuntimeException("Failed to identify primitive type of parameter '" + key + "'");
            }
            throw new RuntimeException("Failed to identify parameter '" + key + "'");
        }
        installerConfigurationMBean.setAttribute(key, castedValue);
    }

    private void setConnectionAttributeFromNestedParam(ConfigurationInstallerComponentClient installerConfigurationMBean) throws Exception {
        for (Param p : this.nestedParams) {
            this.log("Setting attribute " + p.getName() + " = " + p.getValue());
            this.setAttribute(installerConfigurationMBean, p.getName(), p.getValue());
        }
    }

    private void setConnectionAttributeFromPropertiesFile(ConfigurationInstallerComponentClient installerConfigurationMBean, Properties propertiesParams) throws Exception {
        for (Map.Entry<Object, Object> entry : propertiesParams.entrySet()) {
            this.log("Setting attribute from properties " + (String)entry.getKey() + " = " + (String)entry.getValue());
            this.setAttribute(installerConfigurationMBean, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), new PrimitiveConverterBoolean());
        primitiveClasses.put(Boolean.TYPE.getName(), new PrimitiveConverterBoolean());
        primitiveClasses.put(Short.class.getName(), new PrimitiveConverterShort());
        primitiveClasses.put(Short.TYPE.getName(), new PrimitiveConverterShort());
        primitiveClasses.put(Integer.class.getName(), new PrimitiveConverterInteger());
        primitiveClasses.put(Integer.TYPE.getName(), new PrimitiveConverterInteger());
        primitiveClasses.put(Long.class.getName(), new PrimitiveConverterLong());
        primitiveClasses.put(Long.TYPE.getName(), new PrimitiveConverterLong());
        primitiveClasses.put(Float.class.getName(), new PrimitiveConverterFloat());
        primitiveClasses.put(Float.TYPE.getName(), new PrimitiveConverterFloat());
        primitiveClasses.put(Double.class.getName(), new PrimitiveConverterDouble());
        primitiveClasses.put(Double.TYPE.getName(), new PrimitiveConverterDouble());
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

