/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.Deploy;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;
import org.ow2.petals.cli.shell.exception.ShellException;

public class DeployTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Deploy command = new Deploy(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testDeployOneArtifact() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        command.execute(new String[]{"--url", this.componentURL.toString()});
        Assert.assertEquals((long)1L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }

    @Test
    public void testErrorWithMoreThanOneURL() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        try {
            command.execute(new String[]{"--url", this.componentURL.toString(), this.saURL.toString()});
            Assert.fail((String)"Exception 'CommandTooManyArgumentsException' is not thrown");
        }
        catch (CommandTooManyArgumentsException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Too many arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
        catch (CommandException e) {
            Assert.fail((String)"Exception 'CommandTooManyArgumentsException' is not thrown");
        }
    }

    @Test
    public void testDeployOneArtifactWithPropertiesFile() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        URL propertiesFile = Thread.currentThread().getContextClassLoader().getResource("test.properties");
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        command.execute(new String[]{"--url", this.componentURL.toString(), "-f", propertiesFile.toString()});
        Assert.assertEquals((long)1L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }

    @Test
    public void testDeployOneArtifactWithInlinedProperties() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        command.execute(new String[]{"--url", this.componentURL.toString(), "-Dkey1=value1,key2=value2"});
        Assert.assertEquals((long)1L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }

    @Test
    public void testBulkDeploy() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        String path = this.componentURL.getFile();
        File file = new File(path).getParentFile();
        Assert.assertTrue((boolean)file.isDirectory());
        command.execute(new String[]{"-b", file.getPath()});
        Assert.assertEquals((long)5L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }

    @Test(expected=CommandException.class)
    public void testBulkDeployWithNonFileTypeURL() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        Deploy command = new Deploy(dShell.getShell());
        try {
            command.execute(new String[]{"-b", "http://myfile.zip"});
        }
        catch (CommandException e) {
            Assert.assertEquals((Object)"Directory deployment is only allowed for file protocol", (Object)e.getMessage());
            throw e;
        }
    }
}

