/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.Constants;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;
import org.ow2.petals.cli.shell.util.Utils;

public class Deploy
extends Command {
    protected static final String PROPERTIES_FILE_SHORT_OPTION = "f";
    protected static final String PROPERTIES_FILE_LONG_OPTION = "file";
    protected static final String INLINED_PROPERTIES_SHORT_OPTION = "D";
    protected static final Option INLINED_PROPERTIES_OPTION;
    protected static final Option PROPERTIES_FILE_OPTION;
    protected static final Option BULK_OPTION;
    private final HashMap<String, Completer> completers = new HashMap();
    private ArtifactAdministration artifactAdministration;

    public Deploy(Shell shell) {
        super(shell);
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Deploy and start a JBI artifact");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
        this.artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();
        FileNameCompleter c = new FileNameCompleter();
        this.completers.put("b", (Completer)c);
        this.completers.put("u", (Completer)c);
        this.completers.put(PROPERTIES_FILE_SHORT_OPTION, (Completer)c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String[] args) throws CommandException {
        PosixParser parser = new PosixParser();
        try {
            CommandLine cli = parser.parse(this.getOptions(), args);
            if (cli.hasOption("b")) {
                if (!this.checkArguments(args, 2, 2)) {
                    throw new CommandTooManyArgumentsException(this);
                }
                URL url = Utils.toURL(cli.getOptionValue("b"));
                if (!url.getProtocol().equals(PROPERTIES_FILE_LONG_OPTION)) throw new CommandException("Directory deployment is only allowed for file protocol");
                File filePath = new File(url.getFile());
                this.artifactAdministration.deployAndStartArtifacts(this.getUrls(filePath));
                return;
            } else {
                if (!cli.hasOption("u")) return;
                URL url = Utils.toURL(cli.getOptionValue("u"));
                if (cli.hasOption(PROPERTIES_FILE_SHORT_OPTION)) {
                    if (!this.checkArguments(args, 2, 4)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    String propertiesFile = cli.getOptionValue('f');
                    this.artifactAdministration.deployAndStartArtifact(url, Utils.toURL(propertiesFile));
                    return;
                } else if (cli.hasOption(INLINED_PROPERTIES_SHORT_OPTION)) {
                    String[] properties;
                    if (!this.checkArguments(args, 2, 3)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    Properties configurationProperties = new Properties();
                    for (String propertyEntry : properties = cli.getOptionValues(INLINED_PROPERTIES_SHORT_OPTION)) {
                        String[] property = propertyEntry.split("=");
                        if (property.length != 2) {
                            throw new CommandException("Parsing properties: Syntax error");
                        }
                        configurationProperties.put(property[0], property[1]);
                    }
                    this.artifactAdministration.deployAndStartArtifact(url, configurationProperties);
                    return;
                } else {
                    if (!this.checkArguments(args, 2, 2)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    this.artifactAdministration.deployAndStartArtifact(url);
                }
            }
            return;
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        catch (ArtifactAdministrationException e) {
            throw new CommandException(e);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
    }

    private URL[] getUrls(File directory) throws IOException {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith("zip");
            }
        };
        File[] files = directory.listFiles(filter);
        if (files == null) {
            throw new FileNotFoundException(directory.getAbsolutePath() + " (No such file or directory)");
        }
        int length = files.length;
        URL[] urls = new URL[length];
        for (int i = 0; i < length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(BULK_OPTION);
        optionGroup.addOption(Constants.CommonOption.URL_OPTION);
        OptionGroup propertiesOptionGroup = new OptionGroup();
        propertiesOptionGroup.addOption(PROPERTIES_FILE_OPTION);
        propertiesOptionGroup.addOption(INLINED_PROPERTIES_OPTION);
        options.addOptionGroup(optionGroup);
        options.addOptionGroup(propertiesOptionGroup);
        return options;
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        return this.completers;
    }

    static {
        OptionBuilder.withArgName((String)"property1=value1,property2=value2");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"List of '<property-name>=<property-value>', separated by a comma character, where <property-name> is the name of the property to configure with <property-value>. This argument is used only if the artifact is a component. This argument is exclusive with <configuration-file>.");
        INLINED_PROPERTIES_OPTION = OptionBuilder.create((String)INLINED_PROPERTIES_SHORT_OPTION);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"configuration-file");
        OptionBuilder.withLongOpt((String)PROPERTIES_FILE_LONG_OPTION);
        OptionBuilder.withDescription((String)"The local file name or the URL of the properties file used to configure the artifact. This argument is used only if the artifact is a component. This argument is exclusive with <configuration-properties>.");
        PROPERTIES_FILE_OPTION = OptionBuilder.create((String)PROPERTIES_FILE_SHORT_OPTION);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withLongOpt((String)"bulk");
        OptionBuilder.withDescription((String)"Deploy and start artifacts found in the given directory");
        BULK_OPTION = OptionBuilder.create((String)"b");
    }
}

