/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import com.ebmwebsourcing.easycommons.lang.CollectionHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.artifact.Logger;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;
import org.ow2.petals.cli.shell.util.Utils;

public class Loggers
extends Command {
    static final String LOGGER_NAME_REGEXP_SHORT_OPTION = "p";
    static final String LOGGER_NAME_REGEXP_LONG_OPTION = "pattern";
    private static final Option LOGGER_NAME_REGEXP_OPTION;
    private final CommandLineParser clParser = new PosixParser();

    public Loggers(Shell shell) {
        super(shell);
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Return all the loggers");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            CommandLine cli = this.clParser.parse(this.getOptions(), args, false);
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            TreeSet loggers = new TreeSet(containerAdministration.getLoggers());
            if (cli.hasOption(LOGGER_NAME_REGEXP_SHORT_OPTION)) {
                String loggerNameRegex = cli.getOptionValue(LOGGER_NAME_REGEXP_SHORT_OPTION);
                ArrayList<RegexFilter> filters = new ArrayList<RegexFilter>();
                filters.add(new RegexFilter(loggerNameRegex));
                CollectionHelper.filter(loggers, filters);
            } else if (args.length > 0) {
                throw new CommandBadArgumentNumberException(this);
            }
            for (Logger logger : loggers) {
                String loggerName = logger.getName();
                this.getShell().getPrintStream().println((loggerName.isEmpty() ? "<root>" : loggerName) + " " + logger.getLevel());
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (ContainerAdministrationException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        try {
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            LinkedList<String> loggerNames = new LinkedList<String>();
            List loggers = containerAdministration.getLoggers();
            for (Logger logger : loggers) {
                loggerNames.add(logger.getName());
            }
            this.completers.put(LOGGER_NAME_REGEXP_SHORT_OPTION, new StringsCompleter(loggerNames));
        }
        catch (ContainerAdministrationException containerAdministrationException) {
            // empty catch block
        }
        return this.completers;
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        options.addOption(LOGGER_NAME_REGEXP_OPTION);
        return options;
    }

    static {
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)LOGGER_NAME_REGEXP_LONG_OPTION);
        OptionBuilder.withDescription((String)"The regexp to filter logger names.");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withArgName((String)"logger-name-regexp");
        LOGGER_NAME_REGEXP_OPTION = OptionBuilder.create((String)LOGGER_NAME_REGEXP_SHORT_OPTION);
    }

    private class RegexFilter
    implements CollectionHelper.Filter<Logger> {
        private final Pattern pattern;

        public RegexFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(Logger logger) {
            Matcher m = this.pattern.matcher(logger.getName());
            return m.matches();
        }
    }
}

