/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.Constants;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;
import org.ow2.petals.cli.shell.util.Utils;

public class StartArtifact
extends Command {
    private ArtifactAdministration artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();

    public StartArtifact(Shell shell) {
        super(shell, "start-artifact");
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Start a JBI artifact");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
        this.completers.put("u", new FileNameCompleter());
    }

    @Override
    public void execute(String[] args) throws CommandException {
        block12: {
            PosixParser parser = new PosixParser();
            try {
                CommandLine cl = parser.parse(this.getOptions(), args, true);
                if (cl.hasOption("u")) {
                    if (!this.checkArguments(args, 2, 2)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    URL artifactURL = Utils.toURL(cl.getOptionValue("u"));
                    this.artifactAdministration.startArtifact(artifactURL);
                    break block12;
                }
                if (cl.hasOption("a")) {
                    if (!this.checkArguments(args, 2, 3)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    String[] values = cl.getOptionValues("a");
                    if (values.length == 1) {
                        this.artifactAdministration.startArtifact(null, values[0]);
                    } else {
                        this.artifactAdministration.startArtifact(values[1], values[0]);
                    }
                    break block12;
                }
                throw new CommandBadArgumentNumberException(this);
            }
            catch (UnrecognizedOptionException e) {
                throw new CommandBadArgumentNumberException(this);
            }
            catch (MissingArgumentException e) {
                throw new CommandMissingArgumentException(e.getOption());
            }
            catch (ParseException e) {
                throw new CommandException(e);
            }
            catch (MalformedURLException e) {
                throw new CommandException(e);
            }
            catch (ArtifactAdministrationException e) {
                throw new CommandException(e);
            }
        }
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        OptionGroup op = new OptionGroup();
        op.addOption(Constants.CommonOption.ARTIFACT_OPTION);
        op.addOption(Constants.CommonOption.URL_OPTION);
        options.addOptionGroup(op);
        return options;
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        Utils.addArtifactTypeAndNameCompleter((PetalsInteractiveCli)this.getShell(), this.artifactAdministration, this.completers);
        return this.completers;
    }
}

