/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.connection;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.cli.connection.AuthenticatedConnectionParameters;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.connection.PreferenceFileManager;

public class PreferenceFileManagerTest {
    @Test
    public final void testLoadPreferencePropertiesWithEnvVar() throws Exception {
        File tempDir = PreferenceFileManagerTest.createTestPreferenceFile();
        File preferenceFile = new File(tempDir, "conf" + File.separator + "petals-cli.default");
        System.setProperty("PETALS_CLI_PREFS", preferenceFile.getAbsolutePath());
        File preferenceFilePath = PreferenceFileManager.getPreferencePath((String)"/tmp/test");
        Assert.assertEquals((Object)preferenceFile.getAbsolutePath(), (Object)preferenceFilePath.getAbsolutePath());
        System.getProperties().remove("PETALS_CLI_PREFS");
    }

    @Test
    public final void testLoadPreferencePropertiesWithJarPathAndNoEnvVar() throws Exception {
        File tempDir = PreferenceFileManagerTest.createTestPreferenceFile();
        File jarFile = new File(tempDir, "bin/petals-cli.jar");
        File preferenceFile = new File(tempDir, "conf" + File.separator + "petals-cli.default");
        File preferenceFilePath = PreferenceFileManager.getPreferencePath((String)jarFile.getAbsolutePath());
        Assert.assertEquals((Object)preferenceFile.getAbsolutePath(), (Object)preferenceFilePath.getAbsolutePath());
    }

    private static final File createTestPreferenceFile() throws IOException, FileNotFoundException {
        File tempDir = FileSystemHelper.createTempDir();
        File confDir = new File(tempDir, "conf");
        confDir.mkdir();
        Properties properties = new Properties();
        properties.setProperty("testName", "testValue");
        File preferenceFile = new File(confDir, "petals-cli.default");
        properties.store(new FileOutputStream(preferenceFile), "test property list");
        return tempDir;
    }

    @Test
    public final void testInitializeDefaultConnectionAliasWithoutErrors() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        preferenceProperties.setProperty("server1.host", "test1");
        preferenceProperties.setProperty("server1.port", "7458");
        preferenceProperties.setProperty("alias.default", "test1");
        String defaultConnectionAlias = PreferenceFileManager.initializeDefaultConnectionAlias((Properties)preferenceProperties, errors);
        Assert.assertEquals((Object)"test1", (Object)defaultConnectionAlias);
    }

    @Test
    public final void testInitializeDefaultConnectionAliasWithNoDefaultConnectionAlias() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        preferenceProperties.setProperty("server1.host", "test1");
        preferenceProperties.setProperty("server1.port", "7458");
        String defaultConnectionAlias = PreferenceFileManager.initializeDefaultConnectionAlias((Properties)preferenceProperties, errors);
        Assert.assertEquals(null, (Object)defaultConnectionAlias);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertTrue((boolean)errors.contains(String.format("the property '%s' is missing.", "alias.default")));
    }

    @Test
    public final void testInitializeDefaultConnectionAliasWithEmptyPreferenceFile() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        String defaultConnectionAlias = PreferenceFileManager.initializeDefaultConnectionAlias((Properties)preferenceProperties, errors);
        Assert.assertNull((Object)defaultConnectionAlias);
    }

    @Test
    public final void testIntializePreferenceConnectionParametersFromPropertiesWithoutErrors() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        preferenceProperties.setProperty("server1.host", "test1");
        preferenceProperties.setProperty("server1.port", "7458");
        preferenceProperties.setProperty("server2.host", "test2");
        preferenceProperties.setProperty("server2.port", "7459");
        preferenceProperties.setProperty("server2.username", "userTest");
        preferenceProperties.setProperty("server2.password", "pwdTest");
        HashMap preferenceConnectionParameters = PreferenceFileManager.initializePreferenceConnectionParametersFromProperties((Properties)preferenceProperties, errors);
        ConnectionParameters connectionParameter1 = (ConnectionParameters)preferenceConnectionParameters.get("server1");
        Assert.assertEquals((Object)new ConnectionParameters("test1", 7458), (Object)connectionParameter1);
        ConnectionParameters connectionParameter2 = (ConnectionParameters)preferenceConnectionParameters.get("server2");
        Assert.assertEquals((Object)new AuthenticatedConnectionParameters("test2", 7459, "userTest", "pwdTest"), (Object)connectionParameter2);
    }

    @Test
    public final void testIntializePreferenceConnectionParametersFromPropertiesWithErrors() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        preferenceProperties.setProperty("server1.host", "test1");
        preferenceProperties.setProperty("server1.port", "745ds");
        preferenceProperties.setProperty("server2.host", "test2");
        preferenceProperties.setProperty("server2.port", "7459");
        preferenceProperties.setProperty("server2.username", "userTest");
        preferenceProperties.setProperty("server3.host", "test3");
        preferenceProperties.setProperty("server3.port", "7457");
        preferenceProperties.setProperty("server3.password", "pwdTes2t");
        preferenceProperties.setProperty("server4.username", "userTest");
        preferenceProperties.setProperty("server5.usernme", "userIncorect");
        preferenceProperties.setProperty("servefd", "testIncorrect");
        PreferenceFileManager.initializePreferenceConnectionParametersFromProperties((Properties)preferenceProperties, errors);
        Assert.assertEquals((long)8L, (long)errors.size());
        Assert.assertTrue((boolean)errors.contains(String.format("the value '%s' for the property '%s' is incorrect.", "745ds", "server1.port")));
        Assert.assertTrue((boolean)errors.contains(String.format("the credentials for '%s' are invalid: add the password or remove the user.", "server2")));
        Assert.assertTrue((boolean)errors.contains(String.format("the credentials for '%s' are invalid: add the user or remove the password.", "server3")));
        Assert.assertTrue((boolean)errors.contains(String.format("the property '%s' is missing.", "server4.host")));
        Assert.assertTrue((boolean)errors.contains(String.format("the property '%s' is missing.", "server4.port")));
        Assert.assertTrue((boolean)errors.contains(String.format("the credentials for '%s' are invalid: add the password or remove the user.", "server4")));
        Assert.assertTrue((boolean)errors.contains(String.format("the property name '%s' is incorrect.", "server5.usernme")));
        Assert.assertTrue((boolean)errors.contains(String.format("the property name '%s' is incorrect.", "servefd")));
    }

    @Test
    public final void testIntializePreferenceConnectionParametersFromPropertiesWithEmptyPreferenceFile() throws Exception {
        ArrayList errors = new ArrayList();
        Properties preferenceProperties = new Properties();
        HashMap preferenceConnectionParameters = PreferenceFileManager.initializePreferenceConnectionParametersFromProperties((Properties)preferenceProperties, errors);
        Assert.assertNotNull((Object)preferenceConnectionParameters);
        Assert.assertTrue((boolean)preferenceConnectionParameters.isEmpty());
    }
}

