/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandNoArg;
import org.ow2.petals.cli.shell.command.CommandResult;
import org.ow2.petals.cli.shell.exception.ShellException;

public class PetalsInteractiveCliTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("jline.shutdownhook", "true");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("jline.shutdownhook");
    }

    @Test
    public final void testRun_UnregisteredCommandInputStream() throws ShellException {
        ByteArrayOutputStream errBAIS = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errBAIS));
        System.setIn(new ByteArrayInputStream("unknowncommand\n".getBytes()));
        PetalsInteractiveCli shell = new PetalsInteractiveCli(false);
        try {
            shell.run();
            String error = errBAIS.toString();
            Assert.assertFalse((boolean)error.isEmpty());
            Assert.assertTrue((boolean)error.startsWith("ERROR:"));
        }
        catch (ShellException e) {
            Assert.fail((String)"No excpetion MUST be thrown.");
        }
    }

    @Test
    public final void testRun_RightCommandInputStream() throws ShellException {
        ByteArrayOutputStream errBAIS = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errBAIS));
        System.setIn(new ByteArrayInputStream((CommandNoArg.class.getSimpleName().toLowerCase() + "\n").getBytes()));
        PetalsInteractiveCli shell = new PetalsInteractiveCli(false);
        CommandResult cmdRes = new CommandResult();
        shell.register((Command)new CommandNoArg(cmdRes));
        shell.run();
        String error = errBAIS.toString();
        Assert.assertTrue((boolean)error.isEmpty());
        Assert.assertTrue((boolean)cmdRes.isExecuted());
    }

    @Test
    public final void testRun_CommandWithErrorInputStream() throws ShellException {
        ByteArrayOutputStream errBAIS = new ByteArrayOutputStream();
        System.setErr(new PrintStream(errBAIS));
        System.setIn(new ByteArrayInputStream((CommandNoArg.class.getSimpleName().toLowerCase() + " arg1\n").getBytes()));
        PetalsInteractiveCli shell = new PetalsInteractiveCli(false);
        CommandResult cmdRes = new CommandResult();
        shell.register((Command)new CommandNoArg(cmdRes));
        try {
            shell.run();
            String error = errBAIS.toString();
            Assert.assertFalse((boolean)error.isEmpty());
            Assert.assertTrue((boolean)error.startsWith("ERROR:"));
        }
        catch (ShellException e) {
            Assert.fail((String)"No exception MUST be thrown.");
        }
    }
}

