/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.cli.shell.PetalsScript;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.CommandNoArg;
import org.ow2.petals.cli.shell.command.CommandResult;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.ShellException;
import org.ow2.petals.cli.shell.exception.UnknownCommandException;

public class PetalsScriptTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testRun_NullInputStream() throws ShellException {
        TestPetalsScript shell = new TestPetalsScript(null);
        shell.run();
    }

    @Test
    public final void testRun_EmptyInputStream() throws ShellException {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        TestPetalsScript shell = new TestPetalsScript(bais);
        shell.run();
    }

    @Test
    public final void testRun_UnregisteredCommandInputStream() throws ShellException {
        ByteArrayInputStream bais = new ByteArrayInputStream("unknowncommand".getBytes());
        TestPetalsScript shell = new TestPetalsScript(bais);
        try {
            shell.run();
            Assert.fail((String)("Expected exception '" + ShellException.class.getName() + "' not thrown"));
        }
        catch (ShellException e) {
            Assert.assertTrue((boolean)(e instanceof UnknownCommandException));
        }
    }

    @Test
    public final void testRun_RightCommandInputStream() throws ShellException {
        ByteArrayInputStream bais = new ByteArrayInputStream(CommandNoArg.class.getSimpleName().toLowerCase().getBytes());
        TestPetalsScript shell = new TestPetalsScript(bais);
        CommandResult cmdRes = new CommandResult();
        shell.register(new CommandNoArg(cmdRes));
        shell.run();
        Assert.assertTrue((boolean)cmdRes.isExecuted());
    }

    @Test
    public final void testRun_CommandWithErrorInputStream() throws ShellException {
        ByteArrayInputStream bais = new ByteArrayInputStream((CommandNoArg.class.getSimpleName().toLowerCase() + " arg1").getBytes());
        TestPetalsScript shell = new TestPetalsScript(bais);
        CommandResult cmdRes = new CommandResult();
        shell.register(new CommandNoArg(cmdRes));
        try {
            shell.run();
            Assert.fail((String)("Expected exception '" + ShellException.class.getName() + "' not thrown"));
        }
        catch (ShellException e) {
            Assert.assertTrue((boolean)cmdRes.isExecuted());
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof CommandException));
        }
    }

    @Test
    public final void testRun_CommandSuiteWithUnknwonCommandInputStream() throws ShellException {
        StringBuffer commandsFlow = new StringBuffer();
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        commandsFlow.append('\n');
        commandsFlow.append("unknowncommand");
        commandsFlow.append('\n');
        commandsFlow.append(TestCommandNotExecuted.class.getSimpleName().toLowerCase());
        CommandResult cmdRes1 = new CommandResult();
        CommandResult cmdRes2 = new CommandResult();
        ByteArrayInputStream bais = new ByteArrayInputStream(commandsFlow.toString().getBytes());
        TestPetalsScript shell = new TestPetalsScript(bais);
        shell.register(new CommandNoArg(cmdRes1));
        shell.register(new TestCommandNotExecuted(cmdRes2));
        try {
            shell.run();
            Assert.fail((String)("Expected exception '" + ShellException.class.getName() + "' not thrown"));
        }
        catch (ShellException e) {
            Assert.assertTrue((boolean)cmdRes1.isExecuted());
            Assert.assertTrue((boolean)(e instanceof UnknownCommandException));
            Assert.assertFalse((boolean)cmdRes2.isExecuted());
        }
    }

    @Test
    public final void testRun_CommandSuiteWithCommandErrorInputStream() throws ShellException {
        StringBuffer commandsFlow = new StringBuffer();
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        commandsFlow.append('\n');
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase() + " arg1");
        commandsFlow.append('\n');
        commandsFlow.append(TestCommandNotExecuted.class.getSimpleName().toLowerCase());
        CommandResult cmdRes1 = new CommandResult();
        CommandResult cmdRes2 = new CommandResult();
        ByteArrayInputStream bais = new ByteArrayInputStream(commandsFlow.toString().getBytes());
        TestPetalsScript shell = new TestPetalsScript(bais);
        shell.register(new CommandNoArg(cmdRes1));
        shell.register(new TestCommandNotExecuted(cmdRes2));
        try {
            shell.run();
            Assert.fail((String)("Expected exception '" + ShellException.class.getName() + "' not thrown"));
        }
        catch (ShellException e) {
            Assert.assertTrue((boolean)cmdRes1.isExecuted());
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof CommandException));
            Assert.assertFalse((boolean)cmdRes2.isExecuted());
        }
    }

    @Test
    public final void testRun_CallbackWithoutError() throws ShellException {
        StringBuffer commandsFlow = new StringBuffer();
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        commandsFlow.append('\n');
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        commandsFlow.append('\n');
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        CommandResult cmdRes = new CommandResult();
        ByteArrayInputStream bais = new ByteArrayInputStream(commandsFlow.toString().getBytes());
        TestPetalsScriptCallback shell = new TestPetalsScriptCallback(bais);
        shell.register(new CommandNoArg(cmdRes));
        shell.run();
        Assert.assertTrue((boolean)cmdRes.isExecuted());
    }

    @Test
    public final void testRun_CallbackWithError() throws ShellException {
        StringBuffer commandsFlow = new StringBuffer();
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase());
        commandsFlow.append('\n');
        commandsFlow.append(CommandNoArg.class.getSimpleName().toLowerCase() + " arg1");
        commandsFlow.append('\n');
        commandsFlow.append(TestCommandNotExecuted.class.getSimpleName().toLowerCase());
        CommandResult cmdRes1 = new CommandResult();
        CommandResult cmdRes2 = new CommandResult();
        ByteArrayInputStream bais = new ByteArrayInputStream(commandsFlow.toString().getBytes());
        TestPetalsScriptCallback shell = new TestPetalsScriptCallback(bais);
        shell.register(new CommandNoArg(cmdRes1));
        shell.register(new TestCommandNotExecuted(cmdRes2));
        try {
            shell.run();
            Assert.fail((String)("Expected exception '" + ShellException.class.getName() + "' not thrown"));
        }
        catch (ShellException e) {
            Assert.assertTrue((boolean)cmdRes1.isExecuted());
            Throwable cause = e.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof CommandException));
            Assert.assertFalse((boolean)cmdRes2.isExecuted());
        }
    }

    private class TestPetalsScriptCallback
    extends PetalsScript {
        private int counterInvokation;

        public TestPetalsScriptCallback(InputStream is) throws ShellException {
            super(is, System.out, System.err);
            this.counterInvokation = 0;
        }

        protected void onStart() {
            TestCase.assertEquals((int)0, (int)this.counterInvokation++);
        }

        protected void onLine() {
            TestCase.assertTrue((this.counterInvokation++ > 0 ? 1 : 0) != 0);
        }

        protected void onError(Exception e, int lineNumber) throws ShellException {
            TestCase.assertTrue((this.counterInvokation++ > 1 ? 1 : 0) != 0);
            TestCase.assertTrue((lineNumber >= 1 ? 1 : 0) != 0);
            if (e instanceof ShellException) {
                throw (ShellException)((Object)e);
            }
            throw new ShellException((Throwable)e);
        }
    }

    private class TestCommandNotExecuted
    extends Command {
        private final CommandResult cmdRes;

        public TestCommandNotExecuted(CommandResult cmdRes) {
            this.cmdRes = cmdRes;
        }

        public void execute(String[] args) throws CommandException {
            this.cmdRes.setExecuted(true);
            if (args.length > 0) {
                throw new CommandException("Invalid parameter");
            }
        }
    }

    private class TestPetalsScript
    extends PetalsScript {
        public TestPetalsScript(InputStream is) throws ShellException {
            super(is, System.out, System.err);
        }

        protected void onStart() {
        }

        protected void onLine() {
        }

        protected void onError(Exception e, int lineNumber) throws ShellException {
            if (e instanceof ShellException) {
                throw (ShellException)((Object)e);
            }
            throw new ShellException((Throwable)e);
        }
    }
}

