/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.artifact.ArtifactUtils;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.ServiceUnit;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.ListArtifacts;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class ListArtifactsTest
extends AbstractArtifactCommandTest {
    @Test
    public void testExecuteWithoutArtifactsInRegistry() throws CommandException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[0]);
        Assert.assertEquals((Object)"", (Object)dShell.getOut().toString());
    }

    @Test
    public void testExecuteWithTwoArtifactsInRegistry() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        String slName = ArtifactUtils.createArtifact((URL)this.slURL).getName();
        String componentName = ArtifactUtils.createArtifact((URL)this.componentURL).getName();
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        String saName = sa.getName();
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[0]);
        StringBuilder expected = new StringBuilder(slName + " SL\n" + componentName + " STARTED BC\n" + saName + " STARTED SA\n");
        List serviceUnits = sa.getServiceUnits();
        Collections.sort(serviceUnits, command.artifactNameComparator);
        for (ServiceUnit su : serviceUnits) {
            expected.append(su.getName() + " SU\n");
        }
        Assert.assertEquals((Object)expected.toString(), (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactCmdLineError_0() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        try {
            command.execute(new String[]{".*(EIP|eip|soap).*"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown.");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testListArtifactCmdLineError_1() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        try {
            command.execute(new String[]{"SU"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown.");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testListArtifactCmdLineError_2() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        try {
            command.execute(new String[]{"-p", ".*(EIP|eip|soap).*", "SU"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown.");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testListArtifactCmdLineError_3() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        try {
            command.execute(new String[]{"-t", "SU", ".*(EIP|eip|soap).*"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown.");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testListArtifactCmdLineError_4() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        try {
            command.execute(new String[]{".*(EIP|eip|soap).*", "-t", "SU"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown.");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testListArtifactCmdLineError_5() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testListArtifactWithRegexFilter_0() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        String componentName = ArtifactUtils.createArtifact((URL)this.componentURL).getName();
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-p", ".*(EIP|eip|soap).*"});
        String output = dShell.getOut().toString();
        int idxComponent = output.indexOf(componentName);
        Assert.assertTrue((String)"Component not found in the list", (idxComponent > -1 ? 1 : 0) != 0);
        List serviceUnits = sa.getServiceUnits();
        int[] idxSu = new int[serviceUnits.size()];
        int i = 0;
        Collections.sort(serviceUnits, command.artifactNameComparator);
        for (ServiceUnit serviceUnit : serviceUnits) {
            if (!serviceUnit.getName().contains("-EIP-")) continue;
            idxSu[i++] = output.indexOf(serviceUnit.getName());
            if (i == 1) {
                Assert.assertTrue((String)"SU is not at the right place", (idxSu[0] > idxComponent ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)"SU is not at the right place", (idxSu[i - 1] > idxSu[i - 2] ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"SU list has not the right size", (long)4L, (long)i);
    }

    @Test
    public void testListArtifactWithSAFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-t", "SA"});
        Assert.assertEquals((Object)(sa.getName() + " STARTED SA\n"), (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactWithSUFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-t", "SU"});
        StringBuilder expected = new StringBuilder();
        List serviceUnits = sa.getServiceUnits();
        Collections.sort(serviceUnits, command.artifactNameComparator);
        for (ServiceUnit su : serviceUnits) {
            expected.append(su.getName() + " SU\n");
        }
        Assert.assertEquals((Object)expected.toString(), (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactWithBCFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        String componentName = ArtifactUtils.createArtifact((URL)this.componentURL).getName();
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-t", "BC"});
        Assert.assertEquals((Object)(componentName + " STARTED BC\n"), (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactWithSEFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-t", "SE"});
        Assert.assertEquals((Object)"", (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactWithSLFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        String slName = ArtifactUtils.createArtifact((URL)this.slURL).getName();
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-t", "SL"});
        Assert.assertEquals((Object)(slName + " SL\n"), (Object)dShell.getOut().toString());
    }

    @Test
    public void testListArtifactWithRegexAndArtifactTypeFilter() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL, this.componentURL, this.saURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        ListArtifacts command = new ListArtifacts(dShell.getShell());
        command.execute(new String[]{"-p", ".*EIP.*", "-t", "SU"});
        StringBuilder expected = new StringBuilder();
        List serviceUnits = sa.getServiceUnits();
        Collections.sort(serviceUnits, command.artifactNameComparator);
        for (ServiceUnit su : serviceUnits) {
            if (!su.getName().contains("EIP")) continue;
            expected.append(su.getName() + " SU\n");
        }
        Assert.assertEquals((Object)expected.toString(), (Object)dShell.getOut().toString());
    }
}

