/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.RegistryRegexpPatternException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.ListRegistry;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class ListRegistryTest
extends AbstractArtifactCommandTest {
    private static final String INVALID_REGEXP = "{http://petals.ow2.org/}FaultIntegrationItf";

    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        ListRegistry command = new ListRegistry(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testArgumentsError_1() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        ListRegistry command = new ListRegistry(dummyShell.getShell());
        try {
            command.execute(new String[]{"-i", INVALID_REGEXP});
            Assert.fail((String)"RegistryRegexpPatternException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not RegistryRegexpPatternException", (boolean)(e.getCause() instanceof RegistryRegexpPatternException));
            Assert.assertTrue((String)"Invalid regexp is not displayed", (boolean)e.getMessage().contains(INVALID_REGEXP));
        }
    }

    @Test
    public void testArgumentsError_2() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        ListRegistry command = new ListRegistry(dummyShell.getShell());
        try {
            command.execute(new String[]{"-s", INVALID_REGEXP});
            Assert.fail((String)"RegistryRegexpPatternException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not RegistryRegexpPatternException", (boolean)(e.getCause() instanceof RegistryRegexpPatternException));
            Assert.assertTrue((String)"Invalid regexp is not displayed", (boolean)e.getMessage().contains(INVALID_REGEXP));
        }
    }

    @Test
    public void testArgumentsError_3() throws CommandException, ArtifactAdministrationException, ArtifactException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        ListRegistry command = new ListRegistry(dummyShell.getShell());
        try {
            command.execute(new String[]{"-e", INVALID_REGEXP});
            Assert.fail((String)"RegistryRegexpPatternException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not RegistryRegexpPatternException", (boolean)(e.getCause() instanceof RegistryRegexpPatternException));
            Assert.assertTrue((String)"Invalid regexp is not displayed", (boolean)e.getMessage().contains(INVALID_REGEXP));
        }
    }
}

