/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.Loggers;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;

public class LoggersTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        try {
            command.execute(new String[]{"-p"});
        }
        catch (CommandMissingArgumentException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing argument"));
            Assert.assertTrue((String)"The option '-p' has a missing argument.", (boolean)"p".equals(e.getOption().getOpt()));
            Assert.assertTrue((String)"Missing argument is missing in error message.", (boolean)e.getMessage().endsWith("p"));
        }
    }

    @Test
    public void testArgumentsError_1() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        command.execute(new String[0]);
        Assert.assertFalse((String)"No logger is displayed !", (boolean)dummyShell.getOut().toString().isEmpty());
    }

    @Test
    public void testArgumentsError_2() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        try {
            command.execute(new String[]{"logger.1"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testArgumentsError_3() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testExecute_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        command.execute(new String[]{"-p", "logger.1"});
        Assert.assertTrue((String)"The displayed information are not correct !", (boolean)dummyShell.getOut().toString().equals("logger.1 FINEST\n"));
    }

    @Test
    public void testExecute_1() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Loggers command = new Loggers(dummyShell.getShell());
        command.execute(new String[0]);
        Assert.assertTrue((String)"The displayed information are not correct !", (boolean)dummyShell.getOut().toString().startsWith("<root> FINEST\n"));
    }
}

