/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.URL;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.ArtifactUtils;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.ServiceUnit;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.Show;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class ShowTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testExecuteWithoutArgument() {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        try {
            command.execute(new String[0]);
        }
        catch (CommandException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testShowComponentInformation() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        command.execute(new String[]{"-u", this.componentURL.toString()});
        StringBuilder b = new StringBuilder();
        b.append("Identifier:" + a.getName() + "\n");
        b.append("Type:" + a.getType() + "\n");
        b.append("Version:Not available\n");
        b.append("State:" + ArtifactState.State.STARTED + "\n");
        Assert.assertEquals((Object)b.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_0() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        String type = a.getType();
        command.execute(new String[]{"-a", identifier, type});
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append("Identifier:" + a.getName() + "\n");
        expectedOutput.append("Type:" + a.getType() + "\n");
        expectedOutput.append("Version:Not available\n");
        expectedOutput.append("State:" + ArtifactState.State.STARTED + "\n");
        Assert.assertEquals((Object)expectedOutput.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_1() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        command.execute(new String[]{"-a", identifier});
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append("Identifier:" + a.getName() + "\n");
        expectedOutput.append("Type:" + a.getType() + "\n");
        expectedOutput.append("Version:Not available\n");
        expectedOutput.append("State:" + ArtifactState.State.STARTED + "\n");
        Assert.assertEquals((Object)expectedOutput.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_2() throws ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        this.deployStartArtifact(this.saSoapidURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saSoapidURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        Assert.assertEquals((String)"Artifacts have not the same identifier", (Object)sa.getName(), (Object)identifier);
        try {
            command.execute(new String[]{"-a", identifier});
            Assert.fail((String)"ArtifactTypeIsNeededException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactTypeIsNeededException", (boolean)(e.getCause() instanceof ArtifactTypeIsNeededException));
        }
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_3() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        this.deployStartArtifact(this.saSoapidURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saSoapidURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        Assert.assertEquals((String)"Artifacts have not the same identifier", (Object)sa.getName(), (Object)identifier);
        String type = a.getType();
        command.execute(new String[]{"-a", identifier, type});
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append("Identifier:" + a.getName() + "\n");
        expectedOutput.append("Type:" + a.getType() + "\n");
        expectedOutput.append("Version:Not available\n");
        expectedOutput.append("State:" + ArtifactState.State.STARTED + "\n");
        Assert.assertEquals((Object)expectedOutput.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_4() throws ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        this.deployStartArtifact(this.saSoapidURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saSoapidURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Assert.assertEquals((String)"Artifacts have not the same identifier", (Object)sa.getName(), (Object)a.getName());
        Show command = new Show(dummyShell.getShell());
        String type = a.getType();
        try {
            command.execute(new String[]{"-a", type});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_5() throws ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        this.deployStartArtifact(this.saSoapidURL);
        ServiceAssembly sa = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saSoapidURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        Assert.assertEquals((String)"Artifacts have not the same identifier", (Object)sa.getName(), (Object)identifier);
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(a.getType()));
            command.execute(new String[]{"-a", identifier, "SE"});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_6() throws ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String identifier = a.getName();
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(a.getType()));
            command.execute(new String[]{"-a", identifier, "SE"});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
    }

    @Test
    public void testShowArtifactInformationByNameAndIdentifier_7() throws ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.componentURL);
        Component a = (Component)ArtifactUtils.createArtifact((URL)this.componentURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        String type = a.getType();
        try {
            command.execute(new String[]{"-a", type});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
    }

    @Test
    public void testShowServiceAssemblyInformation() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.saURL);
        ServiceAssembly a = (ServiceAssembly)ArtifactUtils.createArtifact((URL)this.saURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        command.execute(new String[]{"-u", this.saURL.toString()});
        StringBuilder b = new StringBuilder();
        b.append("Identifier:" + a.getName() + "\n");
        b.append("Version:Not available\n");
        b.append("State:" + ArtifactState.State.STARTED + "\n");
        StringBuilder expectedSus = new StringBuilder();
        List sus = a.getServiceUnits();
        for (int i = 0; i < sus.size(); ++i) {
            expectedSus.append(((ServiceUnit)sus.get(i)).getName());
            if (i == sus.size() - 1) continue;
            expectedSus.append(" ");
        }
        b.append("ServiceUnits:" + expectedSus + "\n");
        Assert.assertEquals((Object)b.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowSharedLibraryInformation() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL);
        Artifact a = ArtifactUtils.createArtifact((URL)this.slURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        command.execute(new String[]{"-u", this.slURL.toString()});
        StringBuilder b = new StringBuilder();
        b.append("Identifier:" + a.getName() + "\n");
        b.append("Version:Not available\n");
        Assert.assertEquals((Object)b.toString(), (Object)dummyShell.getOut().toString());
    }

    @Test
    public void testShowSharedLibraryExtendedInformation() throws CommandException, ArtifactAdministrationException, ArtifactException {
        this.deployStartArtifact(this.slURL);
        Artifact a = ArtifactUtils.createArtifact((URL)this.slURL);
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Show command = new Show(dummyShell.getShell());
        command.execute(new String[]{"-e", "-u", this.slURL.toString()});
        StringBuilder b = new StringBuilder();
        b.append("Identifier:" + a.getName() + "\n");
        b.append("Version:Not available\n");
        Assert.assertEquals((Object)b.toString(), (Object)dummyShell.getOut().toString());
    }
}

