/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.MalformedURLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.StartArtifact;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.ShellException;

public class StartArtifactTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        StartArtifact command = new StartArtifact(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testStartOneArtifactByURL() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)1L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        command.execute(new String[]{"-u", this.componentURL.toString()});
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STARTED, (Object)((ArtifactState)artifact).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_0() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String name = artifact.getName();
        String type = artifact.getType();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if component is deployed", (long)1L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        command.execute(new String[]{"-a", name, type});
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STARTED, (Object)((ArtifactState)artifact).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_1() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String name = artifact.getName();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if component is deployed", (long)1L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        command.execute(new String[]{"-a", name});
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STARTED, (Object)((ArtifactState)artifact).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_2() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        admin.deployAndStartArtifact(this.saSoapidURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String name = artifact.getName();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if components are deployed", (long)2L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        Artifact artifactComp = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactComp).getState());
        admin.stopArtifact(this.saSoapidURL);
        Artifact artifactSa = admin.getArtifactInfo(this.saSoapidURL);
        Assert.assertEquals((String)"Check if sa is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactSa).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            command.execute(new String[]{"-a", name});
            Assert.fail((String)"ArtifactTypeIsNeededException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactTypeIsNeededException", (boolean)(e.getCause() instanceof ArtifactTypeIsNeededException));
        }
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.componentURL)).getState());
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.saSoapidURL)).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_3() throws ShellException, CommandException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        admin.deployAndStartArtifact(this.saSoapidURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String name = artifact.getName();
        String type = artifact.getType();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if components are deployed", (long)2L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        Artifact artifactComp = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactComp).getState());
        admin.stopArtifact(this.saSoapidURL);
        Artifact artifactSa = admin.getArtifactInfo(this.saSoapidURL);
        Assert.assertEquals((String)"Check if sa is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactSa).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        command.execute(new String[]{"-a", name, type});
        Assert.assertEquals((Object)ArtifactState.State.STARTED, (Object)((ArtifactState)admin.getArtifactInfo(this.componentURL)).getState());
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.saSoapidURL)).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_4() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        admin.deployAndStartArtifact(this.saSoapidURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String type = artifact.getType();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if components are deployed", (long)2L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        Artifact artifactComp = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactComp).getState());
        admin.stopArtifact(this.saSoapidURL);
        Artifact artifactSa = admin.getArtifactInfo(this.saSoapidURL);
        Assert.assertEquals((String)"Check if sa is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactSa).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            command.execute(new String[]{"-a", type});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.componentURL)).getState());
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.saSoapidURL)).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_5() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        admin.deployAndStartArtifact(this.saSoapidURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String identifier = artifact.getName();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if components are deployed", (long)2L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        Artifact artifactComp = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactComp).getState());
        admin.stopArtifact(this.saSoapidURL);
        Artifact artifactSa = admin.getArtifactInfo(this.saSoapidURL);
        Assert.assertEquals((String)"Check if sa is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifactSa).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(artifact.getType()));
            command.execute(new String[]{"-a", identifier, "SE"});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.componentURL)).getState());
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)admin.getArtifactInfo(this.saSoapidURL)).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_6() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String identifier = artifact.getName();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if component is deployed", (long)1L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(artifact.getType()));
            command.execute(new String[]{"-a", identifier, "SE"});
            Assert.fail((String)"ArtifactTypeIsNeededException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
    }

    @Test
    public void testStartOneArtifactByTypeAndName_7() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        admin.deployAndStartArtifact(this.componentURL);
        Artifact artifact = admin.getArtifactInfo(this.componentURL);
        String type = artifact.getType();
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((String)"Check if component is deployed", (long)1L, (long)artifacts.size());
        admin.stopArtifact(this.componentURL);
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((String)"Check if component is stopped", (Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            command.execute(new String[]{"-a", type});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        artifact = admin.getArtifactInfo(this.componentURL);
        Assert.assertEquals((Object)ArtifactState.State.STOPPED, (Object)((ArtifactState)artifact).getState());
    }

    @Test
    public void testStartManyArtifactThrownException_0() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            command.execute(new String[]{"-u", this.componentURL.toString(), this.saURL.toString()});
        }
        catch (CommandException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Too many arguments"));
            Assert.assertTrue((String)"The command usage is missing.", (boolean)e.getMessage().endsWith(command.getName() + " " + command.getUsage()));
        }
    }

    @Test
    public void testStartManyArtifactThrownException_1() throws ShellException, MalformedURLException, ArtifactAdministrationException {
        DummyShellWrapper dShell = new DummyShellWrapper();
        StartArtifact command = new StartArtifact(dShell.getShell());
        try {
            command.execute(new String[]{"-u"});
        }
        catch (CommandException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing argument"));
        }
    }
}

