/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.HashMap;
import java.util.Map;
import jline.console.completer.Completer;
import org.apache.commons.cli.Options;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public abstract class Command {
    private String name;
    private String usage = "";
    private String description = "";
    private String optionsDescription;
    private Options options;
    protected final HashMap<String, Completer> completers = new HashMap();
    private Shell shell;

    protected Options getOptions() {
        return this.options;
    }

    protected String getOptionsDescription() {
        return this.optionsDescription;
    }

    protected void setOptionsDescription(String optionsDescription) {
        this.optionsDescription = optionsDescription;
    }

    public Command() {
        this.name = this.getClass().getSimpleName().toLowerCase();
        this.options = this.createOptions();
    }

    public Command(Shell shell) {
        this();
        this.shell = shell;
    }

    public Command(Shell shell, String cmdName) {
        this.name = cmdName;
        this.shell = shell;
        this.options = this.createOptions();
    }

    public final String getName() {
        return this.name;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final String getDescription() {
        return this.description;
    }

    protected final Shell getShell() {
        return this.shell;
    }

    protected final void setUsage(String usage) {
        this.usage = usage;
    }

    protected final void setDescription(String description) {
        this.description = description;
    }

    public final boolean checkArguments(String[] args, int min) throws CommandException {
        return args != null && args.length >= min;
    }

    public final boolean checkArguments(String[] args, int min, int max) throws CommandException {
        return this.checkArguments(args, min) && args.length <= max;
    }

    public final void reset() {
        this.options = this.createOptions();
    }

    public abstract void execute(String[] var1) throws CommandException;

    public Options createOptions() {
        return new Options();
    }

    public Completer getDefaultCompleter() {
        return null;
    }

    public Map<String, Completer> getOptionCompleters() {
        return this.completers;
    }
}

