/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jline.console.completer.Completer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.cli.connection.AuthenticatedConnectionParameters;
import org.ow2.petals.cli.connection.ConnectionHelper;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.connection.PreferenceFileException;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;

public class Connect
extends Command {
    private static final String CONFIRMATION_SHORT_OPTION = "y";
    private static final Option CONFIRMATION_OPTION;

    public Connect(Shell shell) {
        super(shell);
        StringBuilder usage = new StringBuilder();
        ConnectionHelper.addConnectionUsage(usage, true);
        this.setUsage(usage.toString());
        this.setDescription("Connect to a Petals ESB node");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        Shell shell = this.getShell();
        PrintStream out = shell.getPrintStream();
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.getOptions(), args);
            ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters(cmd, true);
            if (cmd.getOptions().length == 0 && shell instanceof PetalsInteractiveCli) {
                String confirmationResponse;
                String confirmationQuestion;
                String host = connectionParameters.getHost();
                int port = connectionParameters.getPort();
                if (connectionParameters instanceof AuthenticatedConnectionParameters) {
                    String username = ((AuthenticatedConnectionParameters)connectionParameters).getUsername();
                    confirmationQuestion = String.format("Would you like to connect to %s:*****@%s:%d? (y/n) ", username, host, port);
                } else {
                    confirmationQuestion = String.format("Would you like to connect to %s:%d? (y/n) ", host, port);
                }
                while (!(confirmationResponse = ((PetalsInteractiveCli)shell).askQuestion(confirmationQuestion, false)).equals(CONFIRMATION_SHORT_OPTION) && !confirmationResponse.equals("n")) {
                }
                if (confirmationResponse.equals(CONFIRMATION_SHORT_OPTION)) {
                    ConnectionHelper.connect(connectionParameters, shell, true);
                }
            } else {
                AuthenticatedConnectionParameters authenticatedConnectionParameters = ConnectionHelper.connect(connectionParameters, shell, true);
                if (authenticatedConnectionParameters != null) {
                    String confirmation = String.format("Connected on %s:%d with '%s'", authenticatedConnectionParameters.getHost(), authenticatedConnectionParameters.getPort(), authenticatedConnectionParameters.getUsername());
                    out.println(confirmation);
                }
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (ContainerAdministrationException e) {
            throw new CommandException(e);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        catch (PreferenceFileException e) {
            throw new CommandException(e);
        }
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        ConnectionHelper.addConnectionOptions(options);
        options.addOption(CONFIRMATION_OPTION);
        return options;
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        try {
            return ConnectionHelper.getConnectionOptionCompleters();
        }
        catch (PreferenceFileException pfe) {
            return new HashMap<String, Completer>();
        }
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"A flag to skip confirmation.");
        CONFIRMATION_OPTION = OptionBuilder.create((String)CONFIRMATION_SHORT_OPTION);
    }
}

