/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.RegistryAdministration;
import org.ow2.petals.admin.api.exception.RegistryAdministrationException;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;

public class RegistrySync
extends Command {
    private static final String ALL_SHORT_OPTION = "a";
    private static final String ALL_LONG_OPTION = "all";
    private static final Option ALL_OPTION;

    public RegistrySync(Shell shell) {
        super(shell, "registry-sync");
        this.setUsage("[-a]");
        this.setDescription("Synchronize the registry");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 0, 1)) {
            throw new CommandTooManyArgumentsException(this);
        }
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.getOptions(), args);
            RegistryAdministration registryAdministration = AdminFactory.newInstance().createRegistryAdministration();
            if (cmd.hasOption(ALL_SHORT_OPTION)) {
                registryAdministration.synchronizeRegistryOnAllNodes();
            } else {
                registryAdministration.synchronizeRegistry();
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (RegistryAdministrationException e) {
            throw new CommandException(e);
        }
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(ALL_OPTION);
        return options;
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)ALL_LONG_OPTION);
        OptionBuilder.withDescription((String)"A flag to indicate to synchonize all the nodes.");
        ALL_OPTION = OptionBuilder.create((String)ALL_SHORT_OPTION);
    }
}

