/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;

public class Stop
extends Command {
    private static final String SHUTDOWN_SHORT_OPTION = "s";
    private static final String SHUTDOWN_LONG_OPTION = "shutdown";
    private static final Option SHUTDOWN_OPTION;
    private static final String CONFIRMATION_SHORT_OPTION = "y";
    private static final Option CONFIRMATION_OPTION;

    public Stop(Shell shell) {
        super(shell);
        this.setUsage("[-s [-y]]");
        this.setDescription("Stop the container");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.getOptions(), args);
            Shell shell = this.getShell();
            if (!cmd.hasOption(SHUTDOWN_SHORT_OPTION)) {
                if (cmd.hasOption(CONFIRMATION_SHORT_OPTION)) {
                    String message = String.format("Unrecognized option: -%s", CONFIRMATION_SHORT_OPTION);
                    throw new CommandException(message);
                }
                ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
                containerAdministration.stopContainer();
                if (shell instanceof PetalsInteractiveCli) {
                    String prompt = "petals-cli>";
                    ((PetalsInteractiveCli)shell).updatePrompt(prompt);
                }
            } else if (!cmd.hasOption(CONFIRMATION_SHORT_OPTION) && shell instanceof PetalsInteractiveCli) {
                String confirmationQuestion = "Are you sure you want to shutdown the container? (y/n) ";
                String confirmationResponse = ((PetalsInteractiveCli)shell).askQuestion(confirmationQuestion, false);
                if (confirmationResponse.equals(CONFIRMATION_SHORT_OPTION)) {
                    Stop.shutdownContainer(shell);
                }
            } else {
                Stop.shutdownContainer(shell);
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (ContainerAdministrationException e) {
            throw new CommandException(e);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    private static final void shutdownContainer(Shell shell) throws ContainerAdministrationException {
        ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
        containerAdministration.shutdownContainer();
        if (shell instanceof PetalsInteractiveCli) {
            String prompt = "petals-cli>";
            ((PetalsInteractiveCli)shell).updatePrompt(prompt);
        }
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(CONFIRMATION_OPTION);
        options.addOption(SHUTDOWN_OPTION);
        return options;
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)SHUTDOWN_LONG_OPTION);
        OptionBuilder.withDescription((String)"A flag to skip confirmation.");
        SHUTDOWN_OPTION = OptionBuilder.create((String)SHUTDOWN_SHORT_OPTION);
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"A flag to skip confirmation.");
        CONFIRMATION_OPTION = OptionBuilder.create((String)CONFIRMATION_SHORT_OPTION);
    }
}

