/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;

public final class Utils {
    private Utils() {
    }

    public static final URL toURL(String arg) throws MalformedURLException {
        assert (arg != null);
        Pattern p = Pattern.compile("^[a-zA-Z]+:/+");
        boolean containsProtocol = p.matcher(arg).find();
        URL url = containsProtocol ? new URL(arg) : new URL("file://" + arg);
        return url;
    }

    public static String formatOptionsDescription(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        StringWriter sw = new StringWriter();
        helpFormatter.printOptions(new PrintWriter(sw), 74, options, 1, 3);
        return sw.toString();
    }

    public static String formatOptionsUsage(Options options, String commandName) {
        HelpFormatter helpFormatter = new HelpFormatter();
        StringWriter sw = new StringWriter();
        helpFormatter.printUsage(new PrintWriter(sw), 74, commandName, options);
        String result = sw.toString().split(commandName + " ")[1];
        return result;
    }

    public static final String[] getLineArgs(String line) {
        StrMatcher delim = StrMatcher.splitMatcher();
        StrMatcher quote = StrMatcher.quoteMatcher();
        StrTokenizer tokenizer = new StrTokenizer(line, delim, quote);
        String[] args = tokenizer.getTokenArray();
        return args;
    }

    public static void addArtifactTypeAndNameCompleter(PetalsInteractiveCli shell, ArtifactAdministration artifactAdministration, Map<String, Completer> completers) {
        block3: {
            try {
                ArrayList<String> artifactCompleterValue = new ArrayList<String>();
                for (Artifact a : artifactAdministration.listArtifacts()) {
                    artifactCompleterValue.add(a.getType() + " " + a.getName());
                }
                completers.put("a", (Completer)new StringsCompleter(artifactCompleterValue));
            }
            catch (Throwable e) {
                if (!shell.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }
}

