/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.petals.admin.RegistryMock;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycleFactory;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;

public class ArtifactAdministrationMock
extends ArtifactAdministration {
    public void stopAndUndeployAllArtifacts() throws ArtifactAdministrationException {
        Artifact[] artifacts;
        for (Artifact a : artifacts = RegistryMock.getInstance().list()) {
            ArtifactLifecycle aLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)a);
            aLifecycle.stop();
            aLifecycle.shutdown();
            aLifecycle.undeploy();
        }
    }

    public List<Artifact> listArtifacts() throws ArtifactAdministrationException {
        return Arrays.asList(RegistryMock.getInstance().list());
    }

    public Artifact getArtifact(String type, String name) throws ArtifactAdministrationException {
        assert (name != null);
        Artifact[] artifacts = RegistryMock.getInstance().list();
        ArrayList<Artifact> artifactsMatchingName = new ArrayList<Artifact>();
        if (type != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals(type) || !artifact.getName().equals(name)) continue;
                artifactsMatchingName.add(artifact);
            }
        } else {
            for (Artifact artifact : artifacts) {
                if (!artifact.getName().equals(name)) continue;
                artifactsMatchingName.add(artifact);
            }
        }
        if (artifactsMatchingName.size() == 0) {
            throw new ArtifactNotFoundException(type, name);
        }
        if (artifactsMatchingName.size() > 1) {
            throw new ArtifactTypeIsNeededException(name);
        }
        return (Artifact)artifactsMatchingName.get(0);
    }
}

