/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin;

import java.net.URL;
import org.ow2.petals.admin.RegistryMock;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.lifecycle.ComponentLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;

public class ComponentLifecycleMock
extends ComponentLifecycle {
    public ComponentLifecycleMock(Component c) {
        super(c);
    }

    public void deploy(URL artifactUrl) throws ArtifactAdministrationException {
        RegistryMock.getInstance().add((Artifact)this.getComponent());
    }

    public void start() throws ArtifactAdministrationException {
        Component found = (Component)RegistryMock.getInstance().get((Artifact)this.getComponent());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        found.setState(ArtifactState.State.STARTED);
    }

    public void stop() throws ArtifactAdministrationException {
        Component found = (Component)RegistryMock.getInstance().get((Artifact)this.getComponent());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        found.setState(ArtifactState.State.STOPPED);
    }

    public void undeploy() throws ArtifactAdministrationException {
        RegistryMock.getInstance().remove((Artifact)this.getComponent());
    }

    public void shutdown() throws ArtifactAdministrationException {
        Component found = (Component)RegistryMock.getInstance().get((Artifact)this.getComponent());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        found.setState(ArtifactState.State.SHUTDOWN);
    }

    public void updateState() throws ArtifactAdministrationException {
        Component found = (Component)RegistryMock.getInstance().get((Artifact)this.getComponent());
        if (found == null) {
            throw new ArtifactAdministrationException("Artifact not found in registry. Can not update state");
        }
        this.getComponent().setState(found.getState());
    }
}

