/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.artifact.Logger;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.admin.api.exception.InvalidLogLevelException;
import org.ow2.petals.admin.api.exception.LoggerNotFoundException;
import org.ow2.petals.admin.topology.Domain;

public class ContainerAdministrationMock
implements ContainerAdministration {
    public static final String SYSTEM_INFO = "Petals JBI Container 3.3-SNAPSHOTJava(TM) SE Runtime Environment 20.4-b02 Sun Microsystems Inc.Linux 3.3.1-1-ARCH amd64";
    public static final String INVALID_LOGGER_NAME = "invalid.logger";
    public static final String INVALID_LOG_LEVEL = "INVALID_LEVEL";
    public static final String ROOT_LOGGER_NAME = "";
    public static final String ROOT_LEVEL = "FINEST";
    public static final String LOGGER1_LOGGER_NAME = "logger.1";
    public static final String LOGGER1_LEVEL = "FINEST";
    public static final String LOGGER2_LOGGER_NAME = "logger.2";
    public static final String LOGGER2_LEVEL = "INFO";
    private final Map<String, String> loggers = new HashMap<String, String>();

    public ContainerAdministrationMock() {
        this.loggers.put(ROOT_LOGGER_NAME, "FINEST");
        this.loggers.put(LOGGER1_LOGGER_NAME, "FINEST");
        this.loggers.put(LOGGER2_LOGGER_NAME, LOGGER2_LEVEL);
    }

    public void connect(String host, int port, String user, String password) throws ContainerAdministrationException {
    }

    public void disconnect() throws ContainerAdministrationException {
    }

    public String getSystemInfo() throws ContainerAdministrationException {
        return SYSTEM_INFO;
    }

    public void stopContainer() throws ContainerAdministrationException {
    }

    public void shutdownContainer() throws ContainerAdministrationException {
    }

    public Domain getTopology() throws ContainerAdministrationException {
        return null;
    }

    public Properties getServerProperties() throws ContainerAdministrationException {
        return null;
    }

    public void changeLoggerLevel(String loggerName, String loggerLevel) throws LoggerNotFoundException, InvalidLogLevelException, ContainerAdministrationException {
        if (INVALID_LOGGER_NAME.equals(loggerName)) {
            throw new LoggerNotFoundException(loggerName);
        }
        if (INVALID_LOG_LEVEL.equals(loggerLevel)) {
            throw new InvalidLogLevelException(loggerLevel);
        }
        this.loggers.put(loggerName, loggerLevel);
    }

    public List<Logger> getLoggers() throws ContainerAdministrationException {
        LinkedList<Logger> loggers = new LinkedList<Logger>();
        for (Map.Entry<String, String> logger : this.loggers.entrySet()) {
            loggers.add(new Logger(logger.getKey(), logger.getValue()));
        }
        return loggers;
    }
}

