/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.petals.admin.registry.Endpoint;
import org.ow2.petals.admin.registry.RegistryView;

public class RegistryViewMock
implements RegistryView {
    public static final String EP1_NAME = "FaultIntegrationServiceSOAP";
    public static final String EP1_ITF1_NAME = "{http://petals.ow2.org/}FaultIntegrationItf";
    public static final String EP1_SVC1_NAME = "{http://petals.ow2.org/}FaultIntegrationService";
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public RegistryViewMock() {
        ArrayList<String> itfs = new ArrayList<String>();
        itfs.add(EP1_ITF1_NAME);
        this.endpoints.add(new Endpoint(EP1_NAME, Endpoint.EndpointType.INTERNAL, "0", "petals-bc-soap", EP1_SVC1_NAME, itfs));
    }

    public List<Endpoint> getAllEndpoints() {
        return this.endpoints;
    }

    public Map<String, List<Endpoint>> getListOfEndpointsByServiceName() {
        HashMap<String, List<Endpoint>> result = new HashMap<String, List<Endpoint>>();
        for (Endpoint endpoint : this.endpoints) {
            String svcName = endpoint.getServiceName();
            if (result.containsKey(svcName)) {
                ((List)result.get(svcName)).add(endpoint);
                continue;
            }
            result.put(svcName, new ArrayList());
        }
        return result;
    }

    public Map<String, List<Endpoint>> getListOfEndpointsByInterfaceName() {
        HashMap<String, List<Endpoint>> result = new HashMap<String, List<Endpoint>>();
        for (Endpoint endpoint : this.endpoints) {
            for (String itfName : endpoint.getInterfaceNames()) {
                if (result.containsKey(itfName)) {
                    ((List)result.get(itfName)).add(endpoint);
                    continue;
                }
                result.put(itfName, new ArrayList());
            }
        }
        return result;
    }
}

