/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.api.artifact.lifecycle;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.ArtifactLifecycleFactoryMock;
import org.ow2.petals.admin.ComponentLifecycleMock;
import org.ow2.petals.admin.ServiceAssemblyLifecycleMock;
import org.ow2.petals.admin.SharedLibraryLifecycleMock;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.ServiceUnit;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ArtifactLifecycleFactory;

public class ArtifactLifecycleFactoryTest {
    @Test
    public void createArtifactLifecycleTest() {
        System.setProperty("org.ow2.petals.admin.api.artifact.lifecycle.factory", ArtifactLifecycleFactoryMock.class.getName());
        Component bc = new Component("petals-bc-test", Component.ComponentType.BC);
        Component se = new Component("petals-bc-test", Component.ComponentType.BC);
        ServiceAssembly sa = new ServiceAssembly("sa-test");
        SharedLibrary sl = new SharedLibrary("sl-test");
        ArtifactLifecycle artifactLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)bc);
        Assert.assertTrue((boolean)(artifactLifecycle instanceof ComponentLifecycleMock));
        artifactLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)se);
        Assert.assertTrue((boolean)(artifactLifecycle instanceof ComponentLifecycleMock));
        artifactLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)sa);
        Assert.assertTrue((boolean)(artifactLifecycle instanceof ServiceAssemblyLifecycleMock));
        artifactLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)sl);
        Assert.assertTrue((boolean)(artifactLifecycle instanceof SharedLibraryLifecycleMock));
        System.getProperties().remove("org.ow2.petals.admin.api.factory");
    }

    @Test
    public void createArtifactLifecycleWithUnknowArtifactTest() {
        UncheckedException e = null;
        ArtifactLifecycle artifactLifecycle = null;
        Artifact[] artifacts = new Artifact[]{null, new ServiceUnit("test", "petals-bc-test")};
        for (int i = 0; i < artifacts.length; ++i) {
            try {
                artifactLifecycle = ArtifactLifecycleFactory.newInstance((Artifact)artifacts[i]);
            }
            catch (UncheckedException ex) {
                e = ex;
            }
            Assert.assertNull((Object)artifactLifecycle);
            Assert.assertNotNull((Object)((Object)e));
            Assert.assertEquals((Object)"Unknow artifact type", (Object)e.getMessage());
        }
    }
}

