/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.connection;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.cli.connection.AuthenticatedConnectionParameters;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.connection.PreferenceFileException;
import org.ow2.petals.cli.connection.PreferenceFileManager;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public final class ConnectionHelper {
    private static final String ALIAS_SHORT_OPTION = "a";
    private static final String ALIAS_LONG_OPTION = "alias";
    private static final String ALIAS_ARG_NAME = "alias";
    private static final Option ALIAS_OPTION;
    private static final String HOST_SHORT_OPTION = "h";
    private static final String HOST_LONG_OPTION = "host";
    private static final String HOST_ARG_NAME = "host";
    private static final Option HOST_OPTION;
    private static final String PORT_SHORT_OPTION = "n";
    private static final String PORT_LONG_OPTION = "port";
    private static final String PORT_ARG_NAME = "port";
    private static final Option PORT_OPTION;
    private static final String USER_SHORT_OPTION = "u";
    private static final String USER_LONG_OPTION = "user";
    private static final String USER_ARG_NAME = "user";
    private static final Option USER_OPTION;
    private static final String PASSWORD_SHORT_OPTION = "p";
    private static final String PASSWORD_LONG_OPTION = "password";
    private static final String PASSWORD_ARG_NAME = "password";
    private static final Option PASSWORD_OPTION;

    public static final void addConnectionOptions(Options options) {
        options.addOption(ALIAS_OPTION);
        options.addOption(HOST_OPTION);
        options.addOption(PORT_OPTION);
        options.addOption(USER_OPTION);
        options.addOption(PASSWORD_OPTION);
    }

    public static final void addConnectionUsage(StringBuilder usage, boolean withConfirmationFlag) {
        usage.append("[-").append(HOST_SHORT_OPTION).append(" <host> -").append(PORT_SHORT_OPTION).append(" <port> | -").append(HOST_SHORT_OPTION).append(" <host> -").append(PORT_SHORT_OPTION).append(" <port> -").append(USER_SHORT_OPTION).append(" <user> -").append(PASSWORD_SHORT_OPTION).append(" <password> | -").append(ALIAS_SHORT_OPTION).append(" <alias>");
        if (withConfirmationFlag) {
            usage.append(" | -y]");
        } else {
            usage.append("]");
        }
    }

    public static final ConnectionParameters parseConnectionParameters(CommandLine cmd, boolean useDefaultConnection) throws CommandException, PreferenceFileException {
        HashMap<String, ConnectionParameters> preferenceConnectionParameters = PreferenceFileManager.getPreferenceConnectionParameters();
        ConnectionParameters defaultConnectionParameters = PreferenceFileManager.getDefaultConnectionParameters();
        return ConnectionHelper.parseConnectionParameters(cmd, useDefaultConnection, preferenceConnectionParameters, defaultConnectionParameters);
    }

    public static final Map<String, Completer> getConnectionOptionCompleters() throws PreferenceFileException {
        HashMap<String, ConnectionParameters> preferenceConnectionParameters = PreferenceFileManager.getPreferenceConnectionParameters();
        Set<String> aliasSet = preferenceConnectionParameters.keySet();
        HashMap<String, Completer> optionCompleters = new HashMap<String, Completer>();
        optionCompleters.put(ALIAS_SHORT_OPTION, (Completer)new StringsCompleter(aliasSet.toArray(new String[aliasSet.size()])));
        return optionCompleters;
    }

    static final ConnectionParameters parseConnectionParameters(CommandLine cmd, boolean useDefaultConnection, HashMap<String, ConnectionParameters> preferenceConnectionParameters, ConnectionParameters defaultConnectionParameters) throws CommandException, PreferenceFileException {
        ConnectionParameters connectionParameters;
        if (cmd.hasOption(HOST_SHORT_OPTION) && cmd.hasOption(PORT_SHORT_OPTION) && cmd.hasOption(USER_SHORT_OPTION) && cmd.hasOption(PASSWORD_SHORT_OPTION) && !cmd.hasOption(ALIAS_SHORT_OPTION)) {
            try {
                String host = cmd.getOptionValue(HOST_SHORT_OPTION);
                int port = Integer.parseInt(cmd.getOptionValue(PORT_SHORT_OPTION));
                String username = cmd.getOptionValue(USER_SHORT_OPTION);
                String password = cmd.getOptionValue(PASSWORD_SHORT_OPTION);
                connectionParameters = new AuthenticatedConnectionParameters(host, port, username, password);
            }
            catch (NumberFormatException nfe) {
                throw new CommandException("The port parameter is incorrect");
            }
        } else if (!(cmd.hasOption(HOST_SHORT_OPTION) || cmd.hasOption(PORT_SHORT_OPTION) || cmd.hasOption(USER_SHORT_OPTION) || cmd.hasOption(PASSWORD_SHORT_OPTION) || !cmd.hasOption(ALIAS_SHORT_OPTION))) {
            connectionParameters = preferenceConnectionParameters.get(cmd.getOptionValue(ALIAS_SHORT_OPTION));
            if (connectionParameters == null) {
                throw new CommandException("This alias does not exist");
            }
        } else if (!(cmd.hasOption(HOST_SHORT_OPTION) || cmd.hasOption(PORT_SHORT_OPTION) || cmd.hasOption(USER_SHORT_OPTION) || cmd.hasOption(PASSWORD_SHORT_OPTION) || cmd.hasOption(ALIAS_SHORT_OPTION))) {
            if (useDefaultConnection) {
                connectionParameters = defaultConnectionParameters;
                if (connectionParameters == null) {
                    throw new CommandException("No default connection is available. Use 'help connect' for more information");
                }
            } else {
                connectionParameters = null;
            }
        } else {
            throw new CommandException("Bad number of arguments or incompatible arguments");
        }
        return connectionParameters;
    }

    public static final AuthenticatedConnectionParameters connect(ConnectionParameters connectionParameters, Shell shell, boolean askCredentials) throws ContainerAdministrationException, IOException, CommandException {
        String host = connectionParameters.getHost();
        int port = connectionParameters.getPort();
        if (connectionParameters instanceof AuthenticatedConnectionParameters) {
            AuthenticatedConnectionParameters authenticatedConnectionParameters = (AuthenticatedConnectionParameters)connectionParameters;
            String username = authenticatedConnectionParameters.getUsername();
            String password = authenticatedConnectionParameters.getPassword();
            ConnectionHelper.connect(host, port, username, password, shell);
            return authenticatedConnectionParameters;
        }
        if (askCredentials && shell instanceof PetalsInteractiveCli) {
            while (true) {
                boolean retry = false;
                String username = ((PetalsInteractiveCli)shell).askQuestion("Username: ", false);
                String password = ((PetalsInteractiveCli)shell).askQuestion("Password: ", true);
                try {
                    ConnectionHelper.connect(host, port, username, password, shell);
                    return new AuthenticatedConnectionParameters(host, port, username, password);
                }
                catch (ContainerAdministrationException cae) {
                    if (cae.getMessage().endsWith("Authentication failed! Invalid username or password")) {
                        String retryResponse;
                        if ((retryResponse = ((PetalsInteractiveCli)shell).askQuestion("Retry? (y/n) ", false)).equals("y")) continue;
                        return null;
                    }
                    throw cae;
                }
                break;
            }
        }
        throw new CommandException("The username and password are missing for this alias");
    }

    private static final void connect(String host, int port, String username, String password, Shell shell) throws ContainerAdministrationException {
        ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
        containerAdministration.connect(host, port, username, password);
        if (shell instanceof PetalsInteractiveCli) {
            String prompt = String.format("petals-cli@%s:%d>", host, port);
            ((PetalsInteractiveCli)shell).updatePrompt(prompt);
        }
    }

    static {
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("alias");
        OptionBuilder.withLongOpt("alias");
        OptionBuilder.withDescription("Connection alias in the preference file.");
        ALIAS_OPTION = OptionBuilder.create(ALIAS_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("host");
        OptionBuilder.withLongOpt("host");
        OptionBuilder.withDescription("JMX host of the remote petals ESB.");
        HOST_OPTION = OptionBuilder.create(HOST_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("port");
        OptionBuilder.withLongOpt("port");
        OptionBuilder.withDescription("JMX port of the remote petals ESB.");
        PORT_OPTION = OptionBuilder.create(PORT_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("user");
        OptionBuilder.withLongOpt("user");
        OptionBuilder.withDescription("JMX user of the remote petals ESB.");
        USER_OPTION = OptionBuilder.create(USER_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("password");
        OptionBuilder.withLongOpt("password");
        OptionBuilder.withDescription("JMX password of the remote petals ESB.");
        PASSWORD_OPTION = OptionBuilder.create(PASSWORD_SHORT_OPTION);
    }
}

