/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.ow2.petals.cli.Main;
import org.ow2.petals.cli.connection.AuthenticatedConnectionParameters;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.connection.PreferenceFileException;

public final class PreferenceFileManager {
    static final String PREFERENCE_ENV_VAR = "PETALS_CLI_PREFS";
    static final String PREFERENCE_FILE_NAME = "petals-cli.default";
    static final String DEFAULT_ALIAS_PROPERTY = "alias.default";
    private static final String JAR_PATH = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    private static final String HOST_PROPERTY_SUFFIX = ".host";
    private static final String PORT_PROPERTY_SUFFIX = ".port";
    private static final String USERNAME_PROPERTY_SUFFIX = ".username";
    private static final String PASSWORD_PROPERTY_SUFFIX = ".password";
    private static final Collection<String> RECOGNIZED_SUFFIXES = Collections.unmodifiableCollection(Arrays.asList(".host", ".port", ".username", ".password"));
    private static ConnectionParameters defaultConnectionParameters;
    private static HashMap<String, ConnectionParameters> preferenceConnectionParameters;

    private PreferenceFileManager() {
    }

    public static final synchronized ConnectionParameters getDefaultConnectionParameters() throws PreferenceFileException {
        PreferenceFileManager.intializePreferenceConnectionParameters();
        return defaultConnectionParameters;
    }

    public static final synchronized HashMap<String, ConnectionParameters> getPreferenceConnectionParameters() throws PreferenceFileException {
        PreferenceFileManager.intializePreferenceConnectionParameters();
        return preferenceConnectionParameters;
    }

    private static final void intializePreferenceConnectionParameters() throws PreferenceFileException {
        if (preferenceConnectionParameters == null) {
            ArrayList<String> errors = new ArrayList<String>();
            File preferenceFilePath = PreferenceFileManager.getPreferencePath(JAR_PATH);
            if (preferenceFilePath.exists()) {
                Properties preferenceProperties = PreferenceFileManager.loadPreferenceProperties(preferenceFilePath);
                String defaultConnectionAlias = PreferenceFileManager.initializeDefaultConnectionAlias(preferenceProperties, errors);
                preferenceConnectionParameters = PreferenceFileManager.initializePreferenceConnectionParametersFromProperties(preferenceProperties, errors);
                int errorNumber = errors.size();
                if (errorNumber > 0) {
                    StringBuilder errorMessage = new StringBuilder(String.format("The preference file contains %d error(s)", errorNumber));
                    for (String error : errors) {
                        errorMessage.append("\n\t - " + error);
                    }
                    throw new PreferenceFileException(errorMessage.toString());
                }
                defaultConnectionParameters = preferenceConnectionParameters.get(defaultConnectionAlias);
            } else {
                preferenceConnectionParameters = new HashMap();
                defaultConnectionParameters = null;
            }
        }
    }

    static final String initializeDefaultConnectionAlias(Properties preferenceProperties, List<String> errors) throws PreferenceFileException {
        assert (preferenceProperties != null);
        assert (errors != null);
        String defaultConnectionAlias = preferenceProperties.getProperty(DEFAULT_ALIAS_PROPERTY);
        if (defaultConnectionAlias == null) {
            String errorMessage = String.format("the property '%s' is missing.", DEFAULT_ALIAS_PROPERTY);
            errors.add(errorMessage);
        } else {
            preferenceProperties.remove(DEFAULT_ALIAS_PROPERTY);
        }
        return defaultConnectionAlias;
    }

    static final HashMap<String, ConnectionParameters> initializePreferenceConnectionParametersFromProperties(Properties preferenceProperties, List<String> errors) throws PreferenceFileException {
        assert (preferenceProperties != null);
        assert (errors != null);
        HashMap<String, ConnectionParameters> preferenceConnectionParameters = new HashMap<String, ConnectionParameters>();
        ArrayList<String> treatedAlias = new ArrayList<String>();
        Set<String> propertyNames = preferenceProperties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            String errorMessage;
            int endOfEntryAlias = propertyName.lastIndexOf(46);
            if (endOfEntryAlias == -1) {
                String errorMessage2 = String.format("the property name '%s' is incorrect.", propertyName);
                errors.add(errorMessage2);
                continue;
            }
            String propertySuffix = propertyName.substring(endOfEntryAlias);
            if (!RECOGNIZED_SUFFIXES.contains(propertySuffix)) {
                String errorMessage3 = String.format("the property name '%s' is incorrect.", propertyName);
                errors.add(errorMessage3);
                continue;
            }
            String alias = propertyName.substring(0, endOfEntryAlias);
            if (treatedAlias.contains(alias)) continue;
            treatedAlias.add(alias);
            String hostPropertyKey = alias + HOST_PROPERTY_SUFFIX;
            String host = preferenceProperties.getProperty(hostPropertyKey);
            if (host == null) {
                String errorMessage4 = String.format("the property '%s' is missing.", hostPropertyKey);
                errors.add(errorMessage4);
            }
            String portPropertyKey = alias + PORT_PROPERTY_SUFFIX;
            String portString = preferenceProperties.getProperty(portPropertyKey);
            try {
                String errorMessage5;
                ConnectionParameters connectionParameters;
                int port;
                if (portString == null) {
                    errorMessage = String.format("the property '%s' is missing.", portPropertyKey);
                    errors.add(errorMessage);
                    port = -1;
                } else {
                    port = Integer.parseInt(portString);
                }
                String username = preferenceProperties.getProperty(alias + USERNAME_PROPERTY_SUFFIX);
                String password = preferenceProperties.getProperty(alias + PASSWORD_PROPERTY_SUFFIX);
                if (host != null && port != -1 && username != null && password != null) {
                    connectionParameters = new AuthenticatedConnectionParameters(host, port, username, password);
                    preferenceConnectionParameters.put(alias, connectionParameters);
                    continue;
                }
                if (host != null && port != -1 && username == null && password == null) {
                    connectionParameters = new ConnectionParameters(host, port);
                    preferenceConnectionParameters.put(alias, connectionParameters);
                    continue;
                }
                if (username == null && password != null) {
                    errorMessage5 = String.format("the credentials for '%s' are invalid: add the user or remove the password.", alias);
                    errors.add(errorMessage5);
                    continue;
                }
                if (password != null || username == null) continue;
                errorMessage5 = String.format("the credentials for '%s' are invalid: add the password or remove the user.", alias);
                errors.add(errorMessage5);
            }
            catch (NumberFormatException nfe) {
                errorMessage = String.format("the value '%s' for the property '%s' is incorrect.", portString, portPropertyKey);
                errors.add(errorMessage);
            }
        }
        return preferenceConnectionParameters;
    }

    static final File getPreferencePath(String jarPath) {
        String preferencePath = System.getProperty(PREFERENCE_ENV_VAR);
        File preferenceFilePath = null;
        if (preferencePath == null) {
            File cliHome = new File(jarPath).getParentFile().getParentFile();
            preferenceFilePath = new File(cliHome, "conf" + File.separator + PREFERENCE_FILE_NAME);
        } else {
            preferenceFilePath = new File(preferencePath);
        }
        return preferenceFilePath;
    }

    private static final Properties loadPreferenceProperties(File preferenceFilePath) throws PreferenceFileException {
        Properties preferenceProperties = new Properties();
        try {
            FileInputStream is = new FileInputStream(preferenceFilePath);
            preferenceProperties.load(is);
        }
        catch (IOException ioe) {
            throw new PreferenceFileException("Impossible to read the preference file", ioe);
        }
        return preferenceProperties;
    }
}

