/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class Load
extends Command {
    public Load(Shell shell) {
        super(shell);
        this.setUsage("<propertyfile>");
        this.setDescription("Load properties from files");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 1)) {
            throw new CommandBadArgumentNumberException(this);
        }
        try {
            for (String path : args) {
                this.getShell().getPrintStream().println("Loading properties from " + path);
                FileInputStream fis = new FileInputStream(new File(path));
                System.getProperties().load(fis);
            }
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }
}

