/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;

public class Set
extends Command {
    public static final Pattern REGEX_DECLARATION = Pattern.compile("^\\s*([-\\. \\w]+)\\s*[^\\\\][=:]?\\s*(.*)$");

    public Set(Shell shell) {
        super(shell);
        this.setUsage("key [=:] value");
        this.setDescription("Assign a value to the system property named key");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 0, 3)) {
            throw new CommandTooManyArgumentsException(this);
        }
        if (args.length == 0) {
            this.printProperties();
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sb.append(args[i]);
            }
            this.parseDeclaration(sb.toString());
        }
    }

    private void parseDeclaration(String expr) throws CommandException {
        Matcher m = REGEX_DECLARATION.matcher(expr);
        if (!m.matches()) {
            throw new CommandException("invalid syntax in declaration");
        }
        System.setProperty(m.group(1), m.group(2));
    }

    private void printProperties() {
        StringBuilder sb = new StringBuilder();
        Object[] keys = System.getProperties().keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            sb.append((String)key).append('=').append(System.getProperty((String)key)).append('\n');
        }
        this.getShell().getPrintStream().print(sb.toString());
    }
}

