/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.ServiceUnit;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.Constants;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;
import org.ow2.petals.cli.shell.util.Utils;

public class Show
extends Command {
    static final String UNKNOWN_VERSION = "Not available";
    private static final String EXTENDED_INFORMATION_LBL = "Extended information:";
    private static final String EXTENDED_SHORT_OPTION = "e";
    private static final String EXTENDED_LONG_OPTION = "extended";
    protected static final String SERVICEUNITS_LBL = "ServiceUnits";
    protected static final String IDENTIFIER_LBL = "Identifier";
    protected static final String TYPE_LBL = "Type";
    protected static final String STATE_LBL = "State";
    protected static final String VERSION_LBL = "Version";
    protected static final String SEPARATOR = ":";
    private CommandLineParser clParser = new PosixParser();
    private ArtifactAdministration artifactAdministration;

    public Show(Shell shell) {
        super(shell);
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Print informations about a JBI artifact");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
        this.completers.put("u", new FileNameCompleter());
        this.artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();
    }

    @Override
    public void execute(String[] args) throws CommandException {
        block15: {
            boolean extended = false;
            Artifact artifact = null;
            CommandLine cli = null;
            try {
                cli = this.clParser.parse(this.getOptions(), args, false);
                extended = cli.hasOption(EXTENDED_SHORT_OPTION);
                if (cli.hasOption("u")) {
                    if (extended ? !this.checkArguments(args, 3, 3) : !this.checkArguments(args, 2, 2)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    artifact = this.artifactAdministration.getArtifactInfo(Utils.toURL(cli.getOptionValue("u")));
                } else if (cli.hasOption("a")) {
                    if (extended ? !this.checkArguments(args, 3, 4) : !this.checkArguments(args, 2, 3)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    String[] values = cli.getOptionValues("a");
                    artifact = values.length == 1 ? this.artifactAdministration.getArtifactInfo(null, values[0]) : this.artifactAdministration.getArtifactInfo(values[1], values[0]);
                } else {
                    throw new CommandBadArgumentNumberException(this);
                }
                PrintStream ps = this.getShell().getPrintStream();
                if (artifact instanceof Component) {
                    this.printComponentInformation(ps, (Component)artifact, extended);
                    break block15;
                }
                if (artifact instanceof ServiceAssembly) {
                    this.printServiceAssemblyInformation(ps, (ServiceAssembly)artifact, extended);
                    break block15;
                }
                if (artifact instanceof SharedLibrary) {
                    this.printSharedLibraryInformation(ps, (SharedLibrary)artifact, extended);
                    break block15;
                }
                throw new CommandException("Unknown artifact type.");
            }
            catch (UnrecognizedOptionException e) {
                throw new CommandBadArgumentNumberException(this);
            }
            catch (MalformedURLException e) {
                throw new CommandException(e);
            }
            catch (ArtifactAdministrationException e) {
                throw new CommandException(e);
            }
            catch (MissingArgumentException e) {
                throw new CommandMissingArgumentException(e.getOption());
            }
            catch (ParseException e) {
                throw new CommandException(e);
            }
        }
    }

    private void printSharedLibraryInformation(PrintStream ps, SharedLibrary sl, boolean extended) {
        ps.println("Identifier:" + sl.getName());
        ps.println("Version:" + (sl.getVersion() == null ? UNKNOWN_VERSION : sl.getVersion()));
    }

    private void printComponentInformation(PrintStream ps, Component c, boolean extended) {
        ps.println("Identifier:" + c.getName());
        ps.println("Type:" + c.getComponentType());
        ps.println("Version:" + (c.getVersion() == null ? UNKNOWN_VERSION : c.getVersion()));
        ps.println("State:" + c.getState());
    }

    private void printServiceAssemblyInformation(PrintStream ps, ServiceAssembly sa, boolean extended) {
        ps.println("Identifier:" + sa.getName());
        ps.println("Version:" + (sa.getVersion() == null ? UNKNOWN_VERSION : sa.getVersion()));
        ps.println("State:" + sa.getState());
        StringBuilder b = new StringBuilder();
        List sus = sa.getServiceUnits();
        if (extended) {
            ps.println(EXTENDED_INFORMATION_LBL);
            for (ServiceUnit serviceUnit : sus) {
                ps.println("\t" + serviceUnit.getName() + " " + serviceUnit.getTargetComponent());
            }
        } else {
            for (int i = 0; i < sus.size(); ++i) {
                b.append(((ServiceUnit)sus.get(i)).getName());
                if (i == sus.size() - 1) continue;
                b.append(" ");
            }
            ps.println("ServiceUnits:" + b.toString());
        }
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        OptionGroup op = new OptionGroup();
        op.addOption(Constants.CommonOption.ARTIFACT_OPTION);
        op.addOption(Constants.CommonOption.URL_OPTION);
        options.addOptionGroup(op);
        OptionBuilder.withLongOpt(EXTENDED_LONG_OPTION);
        OptionBuilder.withDescription("Display extended information.");
        OptionBuilder.hasArg(false);
        options.addOption(OptionBuilder.create(EXTENDED_SHORT_OPTION));
        return options;
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        Utils.addArtifactTypeAndNameCompleter((PetalsInteractiveCli)this.getShell(), this.artifactAdministration, this.completers);
        return this.completers;
    }
}

