/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.PrintStream;
import java.util.HashMap;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.topology.Container;
import org.ow2.petals.admin.topology.Domain;
import org.ow2.petals.admin.topology.Subdomain;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;

public class TopologyList
extends Command {
    public TopologyList(Shell shell) {
        super(shell, "topology-list");
        this.setUsage("");
        this.setDescription("Get information about the topology this node is part o");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 0, 0)) {
            throw new CommandTooManyArgumentsException(this);
        }
        try {
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            Domain domain = containerAdministration.getTopology();
            StringBuilder topologyInformation = new StringBuilder(String.format("Domain: %s\n", domain.getName()));
            for (Subdomain subdomain : domain.getSubdomains()) {
                topologyInformation.append(String.format("Subdomain: %s\n", subdomain.getName()));
                for (Container container : subdomain.getContainers()) {
                    String containerInformation = String.format("* Container: %s\n** Type: %s\n** Host: %s\n", container.getContainerName(), container.getNodeType().toString().toLowerCase(), container.getHost());
                    topologyInformation.append(containerInformation);
                    HashMap ports = container.getPorts();
                    for (Container.PortType portType : ports.keySet()) {
                        topologyInformation.append(String.format("** %s: %d\n", portType, ports.get(portType)));
                    }
                }
            }
            PrintStream out = this.getShell().getPrintStream();
            out.println(topologyInformation);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

