/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.artifact.lifecycle.ComponentLifecycle;
import org.ow2.petals.admin.api.artifact.lifecycle.ServiceAssemblyLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;
import org.ow2.petals.admin.api.exception.UnsupportedArtifactTypeException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.admin.jmx.artifact.JMXArtifactLifecycleFactory;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.AdminDoesNotExistException;
import org.ow2.petals.jmx.exception.AdminServiceErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;

public class JMXArtifactAdministration
extends ArtifactAdministration {
    protected JMXArtifactAdministration() {
    }

    public void stopAndUndeployAllArtifacts() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            DeploymentServiceClient deploymentServiceClient = client.getDeploymentServiceClient();
            deploymentServiceClient.stopAllServiceAssemblies();
            deploymentServiceClient.shutdownAllServiceAssemblies();
            deploymentServiceClient.undeployAllServiceAssemblies(true);
            InstallationServiceClient installationServiceClient = client.getInstallationServiceClient();
            installationServiceClient.stopAllComponents();
            installationServiceClient.shutdownAllComponents();
            installationServiceClient.uninstallAllComponents();
            installationServiceClient.unloadAllInstallers(true);
            installationServiceClient.uninstallAllSharedLibrary();
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
    }

    public ArrayList<Artifact> listArtifacts() throws ArtifactAdministrationException {
        try {
            String[] saNames;
            ObjectName[] serviceEngines;
            ObjectName[] bindingComponents;
            String[] sls;
            JMXArtifactLifecycleFactory factory = new JMXArtifactLifecycleFactory();
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            JMXClient client = JMXClientConnection.getJMXClient();
            for (String sl : sls = client.getInstallationServiceClient().getInstalledSharedLibraries()) {
                artifacts.add((Artifact)new SharedLibrary(sl));
            }
            for (ObjectName bindingComponent : bindingComponents = client.getAdminServiceClient().getBindingComponents()) {
                String name = bindingComponent.getKeyProperty("name");
                Component component = new Component(name, Component.ComponentType.BC);
                ComponentLifecycle componentLifecycle = factory.createComponentLifecycle(component);
                componentLifecycle.updateState();
                artifacts.add((Artifact)component);
            }
            for (ObjectName serviceEngine : serviceEngines = client.getAdminServiceClient().getEngineComponents()) {
                String name = serviceEngine.getKeyProperty("name");
                Component component = new Component(name, Component.ComponentType.SE);
                ComponentLifecycle componentLifecycle = factory.createComponentLifecycle(component);
                componentLifecycle.updateState();
                artifacts.add((Artifact)component);
            }
            for (String saName : saNames = client.getDeploymentServiceClient().getDeployedServiceAssemblies()) {
                ServiceAssembly serviceAssembly = this.createServiceAssembly(client, saName);
                ServiceAssemblyLifecycle saLifecycle = factory.createServiceAssemblyLifecycle(serviceAssembly);
                saLifecycle.updateState();
                artifacts.add((Artifact)serviceAssembly);
            }
            return artifacts;
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (AdminServiceErrorException asee) {
            throw new ArtifactAdministrationException((Throwable)asee);
        }
        catch (AdminDoesNotExistException adnee) {
            throw new ArtifactAdministrationException((Throwable)adnee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
        catch (InstallationServiceErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (InstallationServiceDoesNotExistException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }

    public Artifact getArtifact(String type, String name) throws UnsupportedArtifactTypeException, ArtifactNotFoundException, ArtifactTypeIsNeededException, ArtifactAdministrationException {
        Artifact artifact;
        if (type != null) {
            if (Component.ComponentType.BC.toString().equals(type)) {
                artifact = this.getArtifactBC(name);
            } else if (Component.ComponentType.SE.toString().equals(type)) {
                artifact = this.getArtifactSE(name);
            } else if ("SL".equals(type)) {
                artifact = this.getArtifactSL(name);
            } else if ("SA".equals(type)) {
                artifact = this.getArtifactSA(name);
            } else {
                throw new UnsupportedArtifactTypeException(type);
            }
            if (artifact == null) {
                throw new ArtifactNotFoundException(type, name);
            }
        } else {
            Artifact artifactBC = this.getArtifactBC(name);
            Artifact artifactSE = this.getArtifactSE(name);
            Artifact artifactSL = this.getArtifactSL(name);
            Artifact artifactSA = this.getArtifactSA(name);
            if (artifactBC != null && artifactSE == null && artifactSL == null && artifactSA == null) {
                artifact = artifactBC;
            } else if (artifactBC == null && artifactSE != null && artifactSL == null && artifactSA == null) {
                artifact = artifactSE;
            } else if (artifactBC == null && artifactSE == null && artifactSL != null && artifactSA == null) {
                artifact = artifactSL;
            } else if (artifactBC == null && artifactSE == null && artifactSL == null && artifactSA != null) {
                artifact = artifactSA;
            } else {
                if (artifactBC == null && artifactSE == null && artifactSL == null && artifactSA == null) {
                    throw new ArtifactNotFoundException(type, name);
                }
                throw new ArtifactTypeIsNeededException(name);
            }
        }
        return artifact;
    }

    private Artifact getArtifactBC(String name) throws ArtifactAdministrationException {
        try {
            ObjectName[] bindingComponents;
            JMXClient client = JMXClientConnection.getJMXClient();
            for (ObjectName bindingComponent : bindingComponents = client.getAdminServiceClient().getBindingComponents()) {
                String bcName = bindingComponent.getKeyProperty("name");
                if (!bcName.equals(name)) continue;
                return new Component(name, Component.ComponentType.BC);
            }
            return null;
        }
        catch (ConnectionErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (AdminServiceErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (AdminDoesNotExistException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }

    private Artifact getArtifactSE(String name) throws ArtifactAdministrationException {
        try {
            ObjectName[] bindingComponents;
            JMXClient client = JMXClientConnection.getJMXClient();
            for (ObjectName bindingComponent : bindingComponents = client.getAdminServiceClient().getEngineComponents()) {
                String seName = bindingComponent.getKeyProperty("name");
                if (!seName.equals(name)) continue;
                return new Component(name, Component.ComponentType.SE);
            }
            return null;
        }
        catch (ConnectionErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (AdminServiceErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (AdminDoesNotExistException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }

    private Artifact getArtifactSL(String name) throws ArtifactAdministrationException {
        try {
            String[] sls;
            JMXClient client = JMXClientConnection.getJMXClient();
            for (String sl : sls = client.getInstallationServiceClient().getInstalledSharedLibraries()) {
                if (!sl.equals(name)) continue;
                return new SharedLibrary(name);
            }
            return null;
        }
        catch (ConnectionErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (InstallationServiceErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (InstallationServiceDoesNotExistException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }

    private Artifact getArtifactSA(String name) throws ArtifactAdministrationException {
        try {
            String[] saNames;
            JMXClient client = JMXClientConnection.getJMXClient();
            for (String saName : saNames = client.getDeploymentServiceClient().getDeployedServiceAssemblies()) {
                if (!saName.equals(name)) continue;
                return this.createServiceAssembly(client, saName);
            }
            return null;
        }
        catch (ConnectionErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (DeploymentServiceErrorException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
        catch (DeploymentServiceDoesNotExistException e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }

    private ServiceAssembly createServiceAssembly(JMXClient client, String saName) throws ArtifactAdministrationException {
        try {
            String descriptor = client.getDeploymentServiceClient().getServiceAssemblyDescriptor(saName);
            ByteArrayInputStream bais = new ByteArrayInputStream(descriptor.getBytes());
            Jbi saJbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)bais);
            bais.close();
            ArrayList<org.ow2.petals.admin.api.artifact.ServiceUnit> serviceUnits = new ArrayList<org.ow2.petals.admin.api.artifact.ServiceUnit>();
            List suDescriptors = saJbiDescriptor.getServiceAssembly().getServiceUnit();
            for (ServiceUnit suDescriptor : suDescriptors) {
                String suName = suDescriptor.getIdentification().getName();
                String suTargetComponentName = suDescriptor.getTarget().getComponentName();
                org.ow2.petals.admin.api.artifact.ServiceUnit serviceUnit = new org.ow2.petals.admin.api.artifact.ServiceUnit(suName, "NOVERSION", suTargetComponentName);
                serviceUnits.add(serviceUnit);
            }
            return new ServiceAssembly(saName, serviceUnits);
        }
        catch (Exception e) {
            throw new ArtifactAdministrationException((Throwable)e);
        }
    }
}

