/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx;

import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;

public final class JMXClientConnection {
    private static final String NO_CURRENT_CONNECTION_ERROR_MESSAGE = "no current connection to a remote Petals ESB";
    public static JMXClient jmxClient;

    public static final synchronized JMXClient createJMXClient(String host, int port, String user, String password) throws ConnectionErrorException {
        if (jmxClient != null) {
            jmxClient.disconnect();
        }
        jmxClient = new JMXClient(host, Integer.valueOf(port), user, password);
        return jmxClient;
    }

    public static final JMXClient getJMXClient() throws ConnectionErrorException {
        if (jmxClient == null) {
            throw new ConnectionErrorException(NO_CURRENT_CONNECTION_ERROR_MESSAGE);
        }
        return jmxClient;
    }

    public static final void disconnectJMXClient() throws ConnectionErrorException {
        if (jmxClient == null) {
            throw new ConnectionErrorException(NO_CURRENT_CONNECTION_ERROR_MESSAGE);
        }
        jmxClient.disconnect();
        jmxClient = null;
    }

    private JMXClientConnection() {
    }
}

