/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx.artifact;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.lifecycle.ComponentLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public class JMXComponentLifecycle
extends ComponentLifecycle {
    protected JMXComponentLifecycle(Component c) {
        super(c);
    }

    public void deploy(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            InstallerComponentClient installer = client.getInstallationServiceClient().loadNewInstaller(artifactUrl);
            Properties parameters = this.getComponent().getParameters();
            if (parameters != null) {
                ConfigurationInstallerComponentClient installerConfigurationMBean = installer.getConfigurationInstallerClient();
                if (installerConfigurationMBean != null) {
                    for (String parameterName : parameters.stringPropertyNames()) {
                        JMXComponentLifecycle.setAttribute(installerConfigurationMBean, parameterName, parameters.getProperty(parameterName));
                    }
                } else {
                    throw new ArtifactAdministrationException("Impossible to set parameters for this component (no installer configuration MBean)");
                }
            }
            installer.install();
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (PerformActionErrorException paee) {
            throw new ArtifactAdministrationException((Throwable)paee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    private static final void setAttribute(ConfigurationInstallerComponentClient installerConfigurationMBean, String parameterName, String parameterStringValue) throws ArtifactAdministrationException {
        assert (parameterStringValue != null);
        try {
            Set configurationAttributes = installerConfigurationMBean.getAttributes().keySet();
            Object parameterValue = null;
            boolean found = false;
            Iterator configurationAttributesIterator = configurationAttributes.iterator();
            while (configurationAttributesIterator.hasNext() && !found) {
                MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)configurationAttributesIterator.next();
                if (!attributeInfo.getName().equals(parameterName)) continue;
                try {
                    String attributeType = attributeInfo.getType();
                    Class<?> attributeClass = Class.forName(attributeType);
                    Method valueOfMethod = attributeClass.getMethod("valueOf", String.class);
                    parameterValue = valueOfMethod.invoke(null, parameterStringValue);
                    found = true;
                }
                catch (NumberFormatException nfe) {
                    String errorMessage = String.format("The value of the parameter '%s' is incorrect", parameterName);
                    throw new ArtifactAdministrationException(errorMessage, (Throwable)nfe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ArtifactAdministrationException((Throwable)cnfe);
                }
                catch (SecurityException se) {
                    throw new ArtifactAdministrationException((Throwable)se);
                }
                catch (NoSuchMethodException nsme) {
                    throw new ArtifactAdministrationException((Throwable)nsme);
                }
                catch (IllegalArgumentException iae) {
                    throw new ArtifactAdministrationException((Throwable)iae);
                }
                catch (IllegalAccessException iae) {
                    throw new ArtifactAdministrationException((Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    throw new ArtifactAdministrationException((Throwable)ite);
                }
            }
            if (!found) {
                String errorMessage = String.format("The parameter '%s' does not exist or is not settable for this component", parameterName);
                throw new ArtifactAdministrationException(errorMessage);
            }
            installerConfigurationMBean.setAttribute(parameterName, parameterValue);
        }
        catch (AttributeErrorException aee) {
            throw new ArtifactAdministrationException((Throwable)aee);
        }
    }

    public void start() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String componentName = this.getComponent().getName();
            boolean isSuccessful = client.getInstallationServiceClient().startComponent(componentName);
            if (!isSuccessful) {
                String errorMessage = String.format("Failed to start the component '%s'", componentName);
                throw new ArtifactAdministrationException(errorMessage.toString());
            }
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    public void stop() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String componentName = this.getComponent().getName();
            boolean isSuccessful = client.getInstallationServiceClient().stopComponent(componentName);
            if (!isSuccessful) {
                String errorMessage = String.format("Failed to stop the component '%s'", componentName);
                throw new ArtifactAdministrationException(errorMessage.toString());
            }
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    public void shutdown() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String componentName = this.getComponent().getName();
            boolean isSuccessful = client.getInstallationServiceClient().shutdownComponent(componentName);
            if (!isSuccessful) {
                String errorMessage = String.format("Failed to shutdown the component '%s'", componentName);
                throw new ArtifactAdministrationException(errorMessage.toString());
            }
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    public void undeploy() throws ArtifactAdministrationException {
        try {
            boolean isSuccessful;
            JMXClient client = JMXClientConnection.getJMXClient();
            String componentName = this.getComponent().getName();
            InstallationServiceClient installationServiceClient = client.getInstallationServiceClient();
            InstallerComponentClient installer = installationServiceClient.loadInstaller(componentName);
            assert (installer != null);
            if (installer.isInstalled()) {
                installer.uninstall();
            }
            if (!(isSuccessful = installationServiceClient.unloadInstaller(componentName))) {
                String errorMessage = String.format("Failed to shutdown the component '%s'", componentName);
                throw new ArtifactAdministrationException(errorMessage.toString());
            }
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
        catch (PerformActionErrorException paee) {
            throw new ArtifactAdministrationException((Throwable)paee);
        }
        catch (InstallerComponentDoesNotExistException icdnee) {
            throw new ArtifactAdministrationException((Throwable)icdnee);
        }
    }

    public void updateState() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String componentName = this.getComponent().getName();
            String state = client.getComponentClient(componentName).getState();
            this.getComponent().setState(ArtifactState.State.fromStringValue((String)state));
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (ComponentErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (ComponentDoesNotExistException cdnee) {
            throw new ArtifactAdministrationException((Throwable)cdnee);
        }
    }
}

