/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx.artifact;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.lifecycle.ServiceAssemblyLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;

public class JMXServiceAssemblyLifecycle
extends ServiceAssemblyLifecycle {
    private static final String SA_SUCCESS_RESULT = "SUCCESS";
    private static final Pattern SA_RESULT_PATTERN = Pattern.compile(".+?<frmwk-task-result>.+?<task-result>(\\w+?)</task-result>.+?<loc-param>(.+?)</loc-param>", 32);
    private static final Pattern SU_RESULT_PATTERN = Pattern.compile(".+?<component-task-result>.+?<task-result>FAILED</task-result>.+?<loc-param>(.+?)</loc-param>.+?<stack-trace>(.+?)</stack-trace>", 32);

    protected JMXServiceAssemblyLifecycle(ServiceAssembly sa) {
        super(sa);
    }

    public void deploy(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String serviceAssemblyReport = client.getDeploymentServiceClient().deploy(artifactUrl);
            JMXServiceAssemblyLifecycle.checkResult(serviceAssemblyReport, "Failed to deploy SU '%s':\n%s", "SA '%s' deployed with some SU deployment in failure", "Failed to deploy SA '%s'");
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }

    public void start() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String saName = this.getServiceAssembly().getName();
            String serviceAssemblyReport = client.getDeploymentServiceClient().start(saName);
            JMXServiceAssemblyLifecycle.checkResult(serviceAssemblyReport, saName, "Failed to start SA '%s'");
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }

    public void stop() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String saName = this.getServiceAssembly().getName();
            String serviceAssemblyReport = client.getDeploymentServiceClient().stop(saName);
            JMXServiceAssemblyLifecycle.checkResult(serviceAssemblyReport, saName, "Failed to stop SA '%s'");
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }

    public void shutdown() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String saName = this.getServiceAssembly().getName();
            String serviceAssemblyReport = client.getDeploymentServiceClient().shutdown(saName);
            JMXServiceAssemblyLifecycle.checkResult(serviceAssemblyReport, saName, "Failed to shutdown SA '%s'");
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }

    public void undeploy() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String serviceAssemblyReport = client.getDeploymentServiceClient().undeploy(this.getServiceAssembly().getName());
            JMXServiceAssemblyLifecycle.checkResult(serviceAssemblyReport, "Failed to undeploy SU '%s':\n%s", "SA '%s' undeployed with some SU undeployment in failure", "Failed to undeploy SA '%s'");
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }

    private static final void checkResult(String serviceAssemblyReport, String suErrorMessageFormat, String saPartialErrorMessageFormat, String saErrorMessageFormat) throws ArtifactAdministrationException {
        boolean isFailed = false;
        StringBuilder errorMessage = new StringBuilder();
        Matcher matcher = SU_RESULT_PATTERN.matcher(serviceAssemblyReport);
        if (matcher.find()) {
            isFailed = true;
            errorMessage.append(String.format(suErrorMessageFormat, matcher.group(1), matcher.group(2)));
        }
        if ((matcher = SA_RESULT_PATTERN.matcher(serviceAssemblyReport)).find()) {
            if (SA_SUCCESS_RESULT.equals(matcher.group(1).toUpperCase())) {
                if (isFailed) {
                    errorMessage.append(String.format(saPartialErrorMessageFormat, matcher.group(2)));
                }
            } else {
                isFailed = true;
                errorMessage.append(String.format(saErrorMessageFormat, matcher.group(2)));
            }
        }
        if (isFailed) {
            throw new ArtifactAdministrationException(errorMessage.toString());
        }
    }

    private static final void checkResult(String serviceAssemblyReport, String errorMessageFormat, String saName) throws ArtifactAdministrationException {
        Matcher matcher = SA_RESULT_PATTERN.matcher(serviceAssemblyReport);
        if (matcher.find() && !SA_SUCCESS_RESULT.equals(matcher.group(1).toUpperCase())) {
            String errorMessage = String.format(errorMessageFormat, saName);
            throw new ArtifactAdministrationException(errorMessage);
        }
    }

    public void updateState() throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String serviceAssemblyName = this.getServiceAssembly().getName();
            String state = client.getDeploymentServiceClient().getState(serviceAssemblyName);
            this.getServiceAssembly().setState(ArtifactState.State.fromStringValue((String)state));
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (DeploymentServiceErrorException dsee) {
            throw new ArtifactAdministrationException((Throwable)dsee);
        }
        catch (DeploymentServiceDoesNotExistException dsdnee) {
            throw new ArtifactAdministrationException((Throwable)dsdnee);
        }
    }
}

