/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx.artifact;

import java.net.URL;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.artifact.lifecycle.SharedLibraryLifecycle;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;

public class JMXSharedLibraryLifecycle
extends SharedLibraryLifecycle {
    protected JMXSharedLibraryLifecycle(SharedLibrary sl) {
        super(sl);
    }

    public void deploy(URL artifactUrl) throws ArtifactAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            client.getInstallationServiceClient().installSharedLibrary(artifactUrl);
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    public void undeploy() throws ArtifactAdministrationException {
        JMXClient client = null;
        try {
            client = JMXClientConnection.getJMXClient();
            String slName = this.getSharedLibrary().getName();
            boolean isSuccessful = client.getInstallationServiceClient().uninstallSharedLibrary(slName);
            if (!isSuccessful) {
                String errorMessage = String.format("Failed to uninstall the SL '%s'", slName);
                throw new ArtifactAdministrationException(errorMessage.toString());
            }
        }
        catch (ConnectionErrorException cee) {
            throw new ArtifactAdministrationException((Throwable)cee);
        }
        catch (InstallationServiceErrorException isee) {
            throw new ArtifactAdministrationException((Throwable)isee);
        }
        catch (InstallationServiceDoesNotExistException isdnee) {
            throw new ArtifactAdministrationException((Throwable)isdnee);
        }
    }

    public void updateState() throws ArtifactAdministrationException {
    }

    public void start() throws ArtifactAdministrationException {
    }

    public void stop() throws ArtifactAdministrationException {
    }

    public void shutdown() throws ArtifactAdministrationException {
    }
}

