/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ow2.petals.admin.api.exception.RegistryRegexpPatternException;
import org.ow2.petals.admin.registry.Endpoint;
import org.ow2.petals.admin.registry.RegistryView;

public class JMXRegistryView
implements RegistryView {
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private final Map<String, List<Endpoint>> endpointsByServiceName = new HashMap<String, List<Endpoint>>();
    private final Map<String, List<Endpoint>> endpointsByInterfaceName = new HashMap<String, List<Endpoint>>();

    public JMXRegistryView(List<Map<String, Object>> endpointMaps, String endpointNameRegex, String serviceNameRegex, String interfaceNameRegex) throws RegistryRegexpPatternException {
        this.initialize(endpointMaps, endpointNameRegex, serviceNameRegex, interfaceNameRegex);
    }

    private void initialize(List<Map<String, Object>> endpointMaps, String endpointNameRegex, String serviceNameRegex, String interfaceNameRegex) throws RegistryRegexpPatternException {
        try {
            Pattern endpointNamePattern = Pattern.compile(endpointNameRegex);
            Pattern serviceNamePattern = Pattern.compile(serviceNameRegex);
            Pattern interfaceNamePattern = Pattern.compile(interfaceNameRegex);
            for (Map<String, Object> endpointMap : endpointMaps) {
                List<Object> endpointsForThisServiceName;
                List<String> interfaceNames;
                String endpointName = (String)endpointMap.get("endpointName");
                String endpointTypeStr = (String)endpointMap.get("type");
                Endpoint.EndpointType endpointType = endpointTypeStr.equals("internal") ? Endpoint.EndpointType.INTERNAL : Endpoint.EndpointType.EXTERNAL;
                String containerName = (String)endpointMap.get("containerName");
                String componentName = (String)endpointMap.get("componentName");
                String serviceName = (String)endpointMap.get("serviceName");
                if (!JMXRegistryView.isSelectedEndpoint(endpointName, serviceName, interfaceNames = Arrays.asList((String[])endpointMap.get("interfaceNames")), endpointNamePattern, serviceNamePattern, interfaceNamePattern)) continue;
                Endpoint endpoint = new Endpoint(endpointName, endpointType, containerName, componentName, serviceName, interfaceNames);
                this.endpoints.add(endpoint);
                if (this.endpointsByServiceName.containsKey(serviceName)) {
                    endpointsForThisServiceName = this.endpointsByServiceName.get(serviceName);
                } else {
                    endpointsForThisServiceName = new ArrayList();
                    this.endpointsByServiceName.put(serviceName, endpointsForThisServiceName);
                }
                endpointsForThisServiceName.add(endpoint);
                for (String interfaceName : interfaceNames) {
                    List<Object> endpointsForThisInterfaceName;
                    if (this.endpointsByInterfaceName.containsKey(interfaceName)) {
                        endpointsForThisInterfaceName = this.endpointsByInterfaceName.get(interfaceName);
                    } else {
                        endpointsForThisInterfaceName = new ArrayList();
                        this.endpointsByInterfaceName.put(interfaceName, endpointsForThisInterfaceName);
                    }
                    endpointsForThisInterfaceName.add(endpoint);
                }
            }
        }
        catch (PatternSyntaxException e) {
            throw new RegistryRegexpPatternException(e.getPattern(), e.getDescription());
        }
    }

    private static final boolean isSelectedEndpoint(String endpointName, String serviceName, List<String> interfaceNames, Pattern endpointNamePattern, Pattern serviceNamePattern, Pattern interfaceNamePattern) {
        boolean isSelectedEndpoint;
        block1: {
            String interfaceName;
            Matcher interfaceNameMatcher;
            Matcher serviceNameMatcher;
            Matcher endpointNameMatcher = endpointNamePattern.matcher(endpointName);
            isSelectedEndpoint = endpointNameMatcher.matches();
            if (!isSelectedEndpoint || !(isSelectedEndpoint = (serviceNameMatcher = serviceNamePattern.matcher(serviceName)).matches())) break block1;
            Iterator<String> i$ = interfaceNames.iterator();
            while (i$.hasNext() && !(isSelectedEndpoint = (interfaceNameMatcher = interfaceNamePattern.matcher(interfaceName = i$.next())).matches())) {
            }
        }
        return isSelectedEndpoint;
    }

    public List<Endpoint> getAllEndpoints() {
        return this.endpoints;
    }

    public Map<String, List<Endpoint>> getListOfEndpointsByServiceName() {
        return this.endpointsByServiceName;
    }

    public Map<String, List<Endpoint>> getListOfEndpointsByInterfaceName() {
        return this.endpointsByInterfaceName;
    }
}

