/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.logger;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.ow2.petals.commons.logger.PetalsLogData;

abstract class AbstractPetalsFormatterTest {
    private static final long FROZEN_TIME = 0L;
    protected static final String TEST_SOAP_ENVELOPE0 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://www.webservicex.net\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <web:GetWeather/>\n   </soapenv:Body>\n</soapenv:Envelope>";

    AbstractPetalsFormatterTest() {
    }

    protected LogRecord newLogRecordWithFrozenTime(Level level, String msg) {
        LogRecord logRecord = new LogRecord(level, msg);
        logRecord.setMillis(0L);
        return logRecord;
    }

    protected static final Source newTestSoapEnvelope(String soapEnvelopeXml) {
        StreamSource source = new StreamSource(new ByteArrayInputStream(soapEnvelopeXml.getBytes()));
        return source;
    }

    protected static final String extractBaseLogMessage(String loggedStuff) {
        return loggedStuff.substring(0, loggedStuff.indexOf(10) + 1);
    }

    protected static final Map<String, String> extractLoggedData(String loggedStuff, String[] expectedLogDataKeys) {
        loggedStuff = loggedStuff.substring(loggedStuff.indexOf(10) + 1);
        StringBuffer patternBuffer = new StringBuffer();
        for (String expectedLogDataKey : expectedLogDataKeys) {
            patternBuffer.append(String.format("%s = '([^']*)'\n", expectedLogDataKey));
        }
        Pattern pattern = Pattern.compile(String.valueOf(patternBuffer));
        Matcher matcher = pattern.matcher(loggedStuff);
        Assert.assertTrue((String)String.format("Log extra data [%s] does not match pattern [%s].", loggedStuff, pattern.toString()), (boolean)matcher.matches());
        HashMap<String, String> extractedLoggedData = new HashMap<String, String>();
        for (int i = 0; i < matcher.groupCount(); ++i) {
            extractedLoggedData.put(expectedLogDataKeys[i], matcher.group(i + 1));
        }
        return extractedLoggedData;
    }

    protected static final class TestPetalsLogData
    extends PetalsLogData {
        private Set<String> extendedDataKeys = new HashSet<String>();

        protected TestPetalsLogData() {
        }

        protected void addSimpleData(String dataKey, String dataValue) {
            this.putData(dataKey, dataValue);
        }

        protected void addExtendedData(String dataKey, String dataValue) {
            this.addSimpleData(dataKey, dataValue);
            this.extendedDataKeys.add(dataKey);
        }

        public boolean isExtendedLogDataKey(String dataKey) {
            return this.extendedDataKeys.contains(dataKey);
        }
    }
}

