/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.logger;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.commons.logger.AbstractPetalsFormatterTest;
import org.ow2.petals.commons.logger.PetalsExtendedFormatter;

public class PetalsExtendedFormatterTest
extends AbstractPetalsFormatterTest {
    @Test
    public final void testExtendedFormattingWithOnlySimpleData() throws Exception {
        PetalsExtendedFormatter formatter = new PetalsExtendedFormatter();
        String msg = "This is a test message";
        for (Level level : com.ebmwebsourcing.easycommons.logger.Level.getLevels()) {
            LogRecord logRecord = this.newLogRecordWithFrozenTime(level, msg);
            logRecord.setLoggerName("myLogger");
            AbstractPetalsFormatterTest.TestPetalsLogData testLogData = new AbstractPetalsFormatterTest.TestPetalsLogData();
            testLogData.addSimpleData("simpleDataKey1", "simpleDataValue1");
            testLogData.addSimpleData("simpleDataKey2", "simpleDataValue2");
            logRecord.setParameters(new Object[]{testLogData});
            String myLog = formatter.format(logRecord);
            Assert.assertEquals((Object)String.format("1970/01/01 01:00:00,000 %s [myLogger] : This is a test message\n", String.valueOf(level)), (Object)PetalsExtendedFormatterTest.extractBaseLogMessage(myLog));
            Map<String, String> extractedLoggedData = PetalsExtendedFormatterTest.extractLoggedData(myLog, new String[]{"simpleDataKey1", "simpleDataKey2"});
            Assert.assertEquals((Object)"simpleDataValue1", (Object)extractedLoggedData.get("simpleDataKey1"));
            Assert.assertEquals((Object)"simpleDataValue2", (Object)extractedLoggedData.get("simpleDataKey2"));
        }
    }

    @Test
    public final void testExtendedFormattingWithSimpleAndExtendedData() throws Exception {
        PetalsExtendedFormatter formatter = new PetalsExtendedFormatter();
        String msg = "This is a test message";
        for (Level level : com.ebmwebsourcing.easycommons.logger.Level.getLevels()) {
            LogRecord logRecord = this.newLogRecordWithFrozenTime(level, msg);
            logRecord.setLoggerName("myLogger");
            AbstractPetalsFormatterTest.TestPetalsLogData testLogData = new AbstractPetalsFormatterTest.TestPetalsLogData();
            testLogData.addSimpleData("simpleDataKey1", "simpleDataValue1");
            testLogData.addExtendedData("extendedDataKey1", "extendedDataValue1");
            testLogData.addSimpleData("simpleDataKey2", "simpleDataValue2");
            testLogData.addExtendedData("extendedDataKey2", "extendedDataValue2");
            logRecord.setParameters(new Object[]{testLogData});
            String myLog = formatter.format(logRecord);
            Assert.assertEquals((Object)String.format("1970/01/01 01:00:00,000 %s [myLogger] : This is a test message\n", String.valueOf(level)), (Object)PetalsExtendedFormatterTest.extractBaseLogMessage(myLog));
            Map<String, String> extractedLoggedData = PetalsExtendedFormatterTest.extractLoggedData(myLog, new String[]{"extendedDataKey1", "extendedDataKey2", "simpleDataKey1", "simpleDataKey2"});
            Assert.assertEquals((Object)"simpleDataValue1", (Object)extractedLoggedData.get("simpleDataKey1"));
            Assert.assertEquals((Object)"extendedDataValue1", (Object)extractedLoggedData.get("extendedDataKey1"));
            Assert.assertEquals((Object)"simpleDataValue2", (Object)extractedLoggedData.get("simpleDataKey2"));
            Assert.assertEquals((Object)"extendedDataValue2", (Object)extractedLoggedData.get("extendedDataKey2"));
        }
    }
}

