/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.logger;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.commons.logger.AbstractPetalsFormatterTest;
import org.ow2.petals.commons.logger.PetalsSimpleFormatter;

public class PetalsSimpleFormatterTest
extends AbstractPetalsFormatterTest {
    @Test
    public final void testSimpleFormattingWithOnlySimpleData() throws Exception {
        PetalsSimpleFormatter formatter = new PetalsSimpleFormatter();
        String msg = "This is a test message";
        for (Level level : com.ebmwebsourcing.easycommons.logger.Level.getLevels()) {
            LogRecord logRecord = this.newLogRecordWithFrozenTime(level, msg);
            logRecord.setLoggerName("myLogger");
            AbstractPetalsFormatterTest.TestPetalsLogData testLogData = new AbstractPetalsFormatterTest.TestPetalsLogData();
            testLogData.addSimpleData("simpleDataKey1", "simpleDataValue1");
            testLogData.addSimpleData("simpleDataKey2", "simpleDataValue2");
            logRecord.setParameters(new Object[]{testLogData});
            String myLog = formatter.format(logRecord);
            Assert.assertEquals((Object)String.format("1970/01/01 01:00:00,000 %s [myLogger] : This is a test message\n", String.valueOf(level)), (Object)PetalsSimpleFormatterTest.extractBaseLogMessage(myLog));
            Map<String, String> extractedLoggedData = PetalsSimpleFormatterTest.extractLoggedData(myLog, new String[]{"simpleDataKey1", "simpleDataKey2"});
            Assert.assertEquals((Object)"simpleDataValue1", (Object)extractedLoggedData.get("simpleDataKey1"));
            Assert.assertEquals((Object)"simpleDataValue2", (Object)extractedLoggedData.get("simpleDataKey2"));
        }
    }

    @Test
    public final void testSimpleFormattingWithSimpleAndExtendedData() throws Exception {
        PetalsSimpleFormatter formatter = new PetalsSimpleFormatter();
        String msg = "This is a test message";
        for (Level level : com.ebmwebsourcing.easycommons.logger.Level.getLevels()) {
            LogRecord logRecord = this.newLogRecordWithFrozenTime(level, msg);
            logRecord.setLoggerName("myLogger");
            AbstractPetalsFormatterTest.TestPetalsLogData testLogData = new AbstractPetalsFormatterTest.TestPetalsLogData();
            testLogData.addSimpleData("simpleDataKey1", "simpleDataValue1");
            testLogData.addExtendedData("extendedDataKey1", "extendedDataValue1");
            testLogData.addSimpleData("simpleDataKey2", "simpleDataValue2");
            testLogData.addExtendedData("extendedDataKey2", "extendedDataValue2");
            logRecord.setParameters(new Object[]{testLogData});
            String myLog = formatter.format(logRecord);
            Assert.assertEquals((Object)String.format("1970/01/01 01:00:00,000 %s [myLogger] : This is a test message\n", String.valueOf(level)), (Object)PetalsSimpleFormatterTest.extractBaseLogMessage(myLog));
            Map<String, String> extractedLoggedData = PetalsSimpleFormatterTest.extractLoggedData(myLog, new String[]{"simpleDataKey1", "simpleDataKey2"});
            Assert.assertEquals((Object)"simpleDataValue1", (Object)extractedLoggedData.get("simpleDataKey1"));
            Assert.assertEquals((Object)"simpleDataValue2", (Object)extractedLoggedData.get("simpleDataKey2"));
        }
    }
}

