/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.logger;

import com.ebmwebsourcing.easycommons.logger.AbstractLogDataAppenderTest;
import com.ebmwebsourcing.easycommons.logger.LogData;
import com.ebmwebsourcing.easycommons.xml.DOMHelper;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.commons.logger.SourceLogDataAppender;

public class SourceLogDataAppenderTest
extends AbstractLogDataAppenderTest {
    private static final String TEST_WELLFORMED_XML_CONTENT = "<toto>mycontent</toto>";
    private static final String TEST_MALFORMED_XML_CONTENT = "<toto>my malformed content</to>";

    private static final InputStream newTestInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes());
    }

    private static final Source[] newAllowedTestSources(String content) {
        return new Source[]{new StreamSource(SourceLogDataAppenderTest.newTestInputStream(content)), DOMHelper.parseAsDOMSource((InputStream)SourceLogDataAppenderTest.newTestInputStream(content))};
    }

    @Test
    public void testCanAppendNullSource() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey", null);
        Assert.assertTrue((boolean)srcAppender.canAppend(logData, "dataKey"));
    }

    @Test
    public void testCanAppendSource() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        for (Source source : SourceLogDataAppenderTest.newAllowedTestSources(TEST_WELLFORMED_XML_CONTENT)) {
            LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey", (Object)source);
            Assert.assertTrue((boolean)srcAppender.canAppend(logData, "dataKey"));
        }
    }

    @Test
    public void testCanAppendButNotSourceType() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        for (Object obj : new Object[]{5, "toto", false, new Date(0L)}) {
            LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey", (Object)obj);
            Assert.assertFalse((boolean)srcAppender.canAppend(logData, "dataKey"));
        }
    }

    @Test
    public void testAppendNullSource() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        StringBuffer sb = new StringBuffer("alreadyInBuffer");
        LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey1", null);
        srcAppender.append(sb, logData, "dataKey1");
        Assert.assertEquals((Object)"alreadyInBufferdataKey1 = null", (Object)sb.toString());
    }

    @Test
    public void testAppendSource() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        for (Source source : SourceLogDataAppenderTest.newAllowedTestSources(TEST_WELLFORMED_XML_CONTENT)) {
            StringBuffer sb = new StringBuffer("alreadyInBuffer");
            LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey1", (Object)source);
            srcAppender.append(sb, logData, "dataKey1");
            Assert.assertTrue((boolean)SourceLogDataAppenderTest.nonNullAppendedSourceEquals("alreadyInBuffer", sb.toString(), "dataKey1", TEST_WELLFORMED_XML_CONTENT));
        }
    }

    @Test
    public void testAppendMalformedStreamSource() {
        SourceLogDataAppender srcAppender = new SourceLogDataAppender();
        StreamSource source = new StreamSource(SourceLogDataAppenderTest.newTestInputStream(TEST_MALFORMED_XML_CONTENT));
        StringBuffer sb = new StringBuffer();
        LogData logData = SourceLogDataAppenderTest.newTestLogData((String)"dataKey1", (Object)source);
        srcAppender.append(sb, logData, "dataKey1");
        Assert.assertEquals((Object)"dataKey1 = '<!-- Malformed source : org.xml.sax.SAXParseException: The element type \"toto\" must be terminated by the matching end-tag \"</toto>\". -->'", (Object)sb.toString());
    }

    private static final boolean nonNullAppendedSourceEquals(String alreadyInBuffer, String appendedSource, String expectedDataKey, String expectedEquivalentSourceContent) {
        String regex = String.format("%s%s = '.*'", alreadyInBuffer, expectedDataKey);
        if (!appendedSource.matches(regex)) {
            return false;
        }
        String xmlContent = SourceLogDataAppenderTest.extractXmlContent(appendedSource);
        return XMLComparator.isEquivalent((String)expectedEquivalentSourceContent, (String)xmlContent);
    }

    private static final String extractXmlContent(String appendedSource) {
        return appendedSource.split("'")[1];
    }
}

