/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jmx.ComponentClient;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractJMXMojo;

public class JBIStopMojo
extends JBIAbstractJMXMojo {
    protected Boolean undeploySAs;

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        try {
            File artifactFile = this.project.getArtifact().getFile();
            if (artifactFile == null) {
                this.attachedJBIArchive(this.project.getArtifact());
            }
            Jbi jbiDescriptor = this.readJbiDescriptor(this.project.getArtifact());
            this.getLog().info((CharSequence)("Using JMX Petals server located at: " + this.host + ":" + this.port));
            JMXClient petalsJMXClient = new JMXClient(this.host, this.port, this.username, this.password);
            if ("jbi-component".equals(this.project.getPackaging())) {
                this.stopComponent(petalsJMXClient, jbiDescriptor);
            } else if ("jbi-service-assembly".equals(this.project.getPackaging())) {
                this.stopServiceAssembly(petalsJMXClient, jbiDescriptor);
            } else if ("jbi-service-unit".equals(this.project.getPackaging())) {
                this.info("Start a service-unit has no sens. This goal is skipped.");
            } else if ("jbi-shared-library".equals(this.project.getPackaging())) {
                this.info("Start a shared-libarary has no sens. This goal is skipped.");
            }
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }

    private void stopComponent(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        block7: {
            try {
                String componentName = this.getComponentNameFromJBIDescriptor(jbiDescriptor);
                ComponentClient pccc = null;
                pccc = petalsJMXClient.getComponentClient(componentName);
                if ("Started".equals(pccc.getState()) || "Stopped".equals(pccc.getState())) {
                    this.checkAndUndeployServiceAssemblies(petalsJMXClient, componentName, "\t");
                    if ("Started".equals(pccc.getState())) {
                        this.info("The component is started. Stopping it ...");
                        pccc.stop();
                        this.info("Component stopped.");
                    }
                    if ("Stopped".equals(pccc.getState())) {
                        this.info("The component is stopped. Shutdowning it ...");
                        pccc.shutdown();
                        this.info("Component shutdowned.");
                    }
                    break block7;
                }
                throw new MojoExecutionException("Error, the component " + componentName + " is in the following state: " + pccc.getState());
            }
            catch (ComponentDoesNotExistException e1) {
                this.warn("The component is not installed. Nor error is raised.");
            }
            catch (ComponentErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
            catch (ConnectionErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
        }
    }

    private void checkAndUndeployServiceAssemblies(JMXClient petalsJMXClient, String componentName, String prefixLog) throws MojoExecutionException {
        if (this.force.booleanValue()) {
            this.info("Force mode activated.");
            try {
                DeploymentServiceClient pdsc = petalsJMXClient.getDeploymentServiceClient();
                String[] serviceAssemblies = pdsc.getDeployedServiceAssembliesForComponent(componentName);
                for (int i = 0; i < serviceAssemblies.length; ++i) {
                    this.info(prefixLog + "Shutdowning the service-assembly: " + serviceAssemblies[i] + " ...");
                    this.shutdownDeployedSA(serviceAssemblies[i], pdsc, prefixLog + "\t");
                    this.info(prefixLog + "service-assembly shutdowned.");
                    if (!this.undeploySAs.booleanValue()) continue;
                    this.info(prefixLog + "Undeploying the service-assembly: " + serviceAssemblies[i] + " ...");
                    pdsc.undeploy(serviceAssemblies[i]);
                    this.info(prefixLog + "service-assembly undeployed.");
                }
            }
            catch (DeploymentServiceErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
            catch (DeploymentServiceDoesNotExistException e) {
                throw new MojoExecutionException("Unable to find the deployment service ", (Exception)((Object)e));
            }
            catch (ConnectionErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
        }
    }

    private void stopServiceAssembly(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        try {
            String serviceAssemblyName = this.getServiceAssemblyNameFromJBIDescriptor(jbiDescriptor);
            DeploymentServiceClient pdsc = petalsJMXClient.getDeploymentServiceClient();
            this.info("Checking service assembly state.");
            if (pdsc.isServiceAssemblyDeployed(serviceAssemblyName)) {
                this.info("The service assembly is deployed.");
                this.shutdownDeployedSA(serviceAssemblyName, pdsc, "\t");
            } else {
                this.warn("The service-assembly " + serviceAssemblyName + " is not deployed.");
            }
        }
        catch (DeploymentServiceDoesNotExistException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (DeploymentServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }

    private void shutdownDeployedSA(String serviceAssemblyName, DeploymentServiceClient pdsc, String prefixLog) throws MojoExecutionException {
        try {
            String result;
            if ("Started".equals(pdsc.getState(serviceAssemblyName))) {
                this.info(prefixLog + "Stopping the service assembly.");
                result = pdsc.stop(serviceAssemblyName);
                this.info(prefixLog + "The service assembly is stopped: " + result);
            }
            if ("Stopped".equals(pdsc.getState(serviceAssemblyName))) {
                this.info(prefixLog + "Shutdowning the service assembly.");
                result = pdsc.shutdown(serviceAssemblyName);
                this.info(prefixLog + "The service assembly is shutdowned: " + result);
            }
            if (!"Shutdown".equals(pdsc.getState(serviceAssemblyName))) {
                throw new MojoExecutionException("Error, the service assembly " + serviceAssemblyName + " is in the following state: " + pdsc.getState(serviceAssemblyName));
            }
        }
        catch (DeploymentServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }
}

