/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;

public abstract class JBIAbstractMojo
extends AbstractMojo {
    protected static final String PACKAGING_COMPONENT = "jbi-component";
    protected static final String PACKAGING_SU = "jbi-service-unit";
    protected static final String PACKAGING_SA = "jbi-service-assembly";
    protected static final String PACKAGING_SL = "jbi-shared-library";
    protected String jbiName;
    protected boolean verbose;
    protected ArtifactRepository localRepository;
    protected File outputDirectory;
    protected MavenProject project;
    protected Artifact projectArtifact;
    protected String packaging;
    protected File jbiDirectory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected MavenSettingsBuilder settingsBuilder;

    protected final Jbi readJbiDescriptor(Artifact artifact) throws MojoExecutionException {
        try {
            File artifactFile = artifact.getFile();
            if (artifactFile == null) {
                throw new MojoExecutionException("Artifact file undefined (is null).");
            }
            this.debug("Read JBI descriptor from JBI archive: " + artifactFile.getAbsolutePath());
            ZipFile zipFile = new ZipFile(artifactFile);
            ZipEntry jbiDescriptorZipEntry = zipFile.getEntry("META-INF/jbi.xml");
            InputStream jbiDescriptorInputStream = zipFile.getInputStream(jbiDescriptorZipEntry);
            Jbi jbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiDescriptorInputStream);
            if (jbiDescriptor == null) {
                throw new MojoExecutionException("JBI Descriptor is null");
            }
            return jbiDescriptor;
        }
        catch (JBIDescriptorException e) {
            throw new MojoExecutionException("Error loading JBI descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error retrieving the JBI descriptor in the JBI archive or loading the jbi xsd schema", (Exception)e);
        }
    }

    protected void attachedJBIArchive(Artifact artifact) {
        this.projectArtifact.setFile(new File(this.outputDirectory + File.separator + this.jbiName + ".zip"));
    }

    protected void debug(String msg) {
        this.getLog().debug((CharSequence)msg);
    }

    protected void info(String msg) {
        if (this.verbose) {
            this.getLog().info((CharSequence)msg);
        }
    }

    protected void warn(String msg) {
        this.getLog().warn((CharSequence)msg);
    }

    protected void error(String msg) {
        this.getLog().error((CharSequence)msg);
    }

    protected void error(String msg, Throwable exception) {
        this.getLog().error((CharSequence)msg, exception);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packagingIsOkForGoal()) {
            this.executeMojo();
        } else {
            this.debug("The project is not a JBI artifact so the plugin skips it.");
        }
    }

    protected boolean packagingIsOkForGoal() {
        return PACKAGING_COMPONENT.equals(this.project.getPackaging()) || PACKAGING_SA.equals(this.project.getPackaging()) || PACKAGING_SL.equals(this.project.getPackaging()) || PACKAGING_SU.equals(this.project.getPackaging());
    }

    protected MavenProject buildProjectFromArtifact(Artifact artifact) throws ProjectBuildingException {
        return this.mavenProjectBuilder.buildFromRepository(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
    }

    protected Artifact createDependencyArtifact(Dependency dependency) throws InvalidVersionSpecificationException {
        Artifact dependencyArtifact = this.artifactFactory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersionSpec((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope(), null, dependency.isOptional());
        return dependencyArtifact;
    }

    protected List<Artifact> getSharedLibraries(MavenProject lProject) throws MojoExecutionException {
        try {
            ArrayList<Artifact> result = new ArrayList<Artifact>();
            List deps = lProject.getDependencies();
            for (Dependency dependency : deps) {
                if (!dependency.getType().equals(PACKAGING_SL)) continue;
                Artifact artifact = this.createDependencyArtifact(dependency);
                result.add(artifact);
            }
            return result;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
    }

    protected abstract void executeMojo() throws MojoExecutionException, MojoFailureException;
}

