/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.plugin.jbiplugin;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.ow2.petals.jbi.descriptor.original.generated.Component;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jmx.ComponentClient;
import org.ow2.petals.jmx.DeploymentServiceClient;
import org.ow2.petals.jmx.InstallationServiceClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.plugin.jbiplugin.JBIAbstractJMXMojo;

public class JBIInstallMojo
extends JBIAbstractJMXMojo {
    private Boolean startMissingComponents;
    private Boolean installMissingSharedLibraries;
    private String serverId;
    private String protocol;
    private String remoteDirectory;
    private WagonManager wagonManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("jbi-component") || this.project.getPackaging().equals("jbi-service-unit") || this.project.getPackaging().equals("jbi-service-assembly") || this.project.getPackaging().equals("jbi-shared-library")) {
            try {
                File artifactFile = this.project.getArtifact().getFile();
                if (artifactFile == null) {
                    this.attachedJBIArchive(this.project.getArtifact());
                }
                Jbi jbiDescriptor = this.readJbiDescriptor(this.project.getArtifact());
                this.info("Using JMX Petals server located at: " + this.host + ":" + this.port);
                JMXClient petalsJMXClient = new JMXClient(this.host, this.port, this.username, this.password);
                if ("jbi-component".equals(this.project.getPackaging())) {
                    this.installComponent(petalsJMXClient, jbiDescriptor);
                    return;
                }
                if ("jbi-service-unit".equals(this.project.getPackaging())) {
                    this.info("Install a service-unit has no sens. This goal is skipped.");
                    return;
                }
                if ("jbi-service-assembly".equals(this.project.getPackaging())) {
                    this.installServiceAssembly(petalsJMXClient, jbiDescriptor);
                    return;
                }
                if (!"jbi-shared-library".equals(this.project.getPackaging())) return;
                this.installSharedLibrary(petalsJMXClient, jbiDescriptor);
                return;
            }
            catch (ConnectionErrorException e) {
                throw new MojoExecutionException("Error", (Exception)((Object)e));
            }
        } else {
            this.info("This artefact is not a JBI artefact. Skiped.");
        }
    }

    private void installComponent(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        try {
            URL jbiPackageURL = new File(this.outputDirectory + File.separator + this.jbiName + ".zip").toURI().toURL();
            this.installComponentCore(petalsJMXClient, jbiDescriptor, jbiPackageURL, "");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
    }

    private void installComponentCore(JMXClient petalsJMXClient, Jbi jbiDescriptor, URL jbiPackageURL, String prefixLog) throws MojoExecutionException {
        try {
            boolean componentInstalled = true;
            boolean componentInstallerLoaded = true;
            String componentName = this.getComponentNameFromJBIDescriptor(jbiDescriptor);
            ComponentClient pccc = null;
            InstallerComponentClient picc = null;
            InstallationServiceClient pisc = petalsJMXClient.getInstallationServiceClient();
            try {
                pccc = petalsJMXClient.getComponentClient(componentName);
            }
            catch (ComponentDoesNotExistException e1) {
                this.info(prefixLog + "The component is not installed.");
                componentInstalled = false;
            }
            try {
                picc = petalsJMXClient.getInstallerComponentClient(componentName);
            }
            catch (InstallerComponentDoesNotExistException e1) {
                this.info(prefixLog + "The component installer is not loaded.");
                componentInstallerLoaded = false;
            }
            if (!this.force.booleanValue() && componentInstalled) {
                throw new MojoExecutionException("The component is already installed");
            }
            if (!this.force.booleanValue() && componentInstallerLoaded) {
                throw new MojoExecutionException("The component installer is already loaded");
            }
            if (this.force.booleanValue()) {
                this.info(prefixLog + "The force mode is asked.");
                if (componentInstalled) {
                    if ("Started".equals(pccc.getState())) {
                        this.info(prefixLog + "Stoping the component.");
                        pccc.stop();
                    }
                    if ("Stopped".equals(pccc.getState())) {
                        this.checkAndUndeployServiceAssemblies(petalsJMXClient, componentName, "\t");
                        this.info(prefixLog + "Shutdowning the component.");
                        pccc.shutdown();
                    }
                    if (!"Shutdown".equals(pccc.getState())) {
                        throw new MojoExecutionException("The component is not in the expected state (SHUTDOWN)");
                    }
                    this.info(prefixLog + "The component is shutdowned.");
                    if (picc.isInstalled()) {
                        this.info(prefixLog + "Uninstalling the component.");
                        picc.uninstall();
                    }
                    this.info(prefixLog + "The component is not installed.");
                }
                if (componentInstallerLoaded) {
                    this.info(prefixLog + "Unloading the component installer.");
                    pisc.unloadInstaller(componentName);
                    this.info(prefixLog + "The component installer is not loaded.");
                }
            }
            if (this.force.booleanValue()) {
                this.info(prefixLog + "Checking needed shared-libraries ...");
                this.checkAndInstallSharedLibraries(petalsJMXClient, jbiDescriptor, prefixLog + "\t");
                this.info(prefixLog + "Needed shared-libraries installed.");
            }
            jbiPackageURL = this.uploadJBIArchiveIfNeeded(jbiPackageURL, prefixLog + "\t");
            this.info(prefixLog + "Loading the component installer (" + jbiPackageURL.toExternalForm() + ").");
            picc = pisc.loadNewInstaller(jbiPackageURL);
            this.info(prefixLog + "The component installer is loaded.");
            this.info(prefixLog + "Installing the component.");
            picc.install();
            this.info(prefixLog + "The component is installed.");
        }
        catch (ComponentErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (PerformActionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (InstallationServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (InstallationServiceDoesNotExistException e) {
            throw new MojoExecutionException("Unable to find the installation service ", (Exception)((Object)e));
        }
    }

    private void installServiceAssembly(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        try {
            String serviceAssemblyName = this.getServiceAssemblyNameFromJBIDescriptor(jbiDescriptor);
            URL jbiPackageURL = new File(this.outputDirectory + File.separator + this.jbiName + ".zip").toURI().toURL();
            this.installServiceAssemblyCore(petalsJMXClient, jbiDescriptor, serviceAssemblyName, jbiPackageURL, this.force, "");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
    }

    private void installServiceAssemblyCore(JMXClient petalsJMXClient, Jbi jbiDescriptor, String serviceAssemblyName, URL jbiPackageURL, boolean forceInstallation, String prefixLog) throws MojoExecutionException {
        try {
            String result;
            DeploymentServiceClient pdsc = petalsJMXClient.getDeploymentServiceClient();
            boolean serviceAssemblyFound = pdsc.isServiceAssemblyDeployed(serviceAssemblyName);
            if (!forceInstallation && serviceAssemblyFound) {
                throw new MojoExecutionException("The service-assembly is already deployed");
            }
            if (!serviceAssemblyFound) {
                this.info(prefixLog + "Service-assembly is not deployed.");
            }
            if (forceInstallation && serviceAssemblyFound) {
                this.info(prefixLog + "The force mode is asked.");
                this.info(prefixLog + "The service-assembly will be undeployed.");
                if ("Started".equals(pdsc.getState(serviceAssemblyName))) {
                    this.info("The service assembly is started, we stop it.");
                    result = pdsc.stop(serviceAssemblyName);
                    this.info("service-assembly successfully stopped: " + result);
                }
                if ("Stopped".equals(pdsc.getState(serviceAssemblyName))) {
                    this.info("The service assembly is stopped, we shutdown it.");
                    result = pdsc.shutdown(serviceAssemblyName);
                    this.info("service-assembly successfully shutdowned: " + result);
                }
                if ("Shutdown".equals(pdsc.getState(serviceAssemblyName))) {
                    this.info("The service assembly is shutdowned, we undeploy it.");
                    result = pdsc.undeploy(serviceAssemblyName);
                    this.info(prefixLog + "service-assembly successfully undeployed: " + result);
                } else {
                    throw new MojoExecutionException("Error, the service assembly " + serviceAssemblyName + " is in the following state: " + pdsc.getState(serviceAssemblyName));
                }
            }
            this.info(prefixLog + "Checking needed components ...");
            this.checkAndStartComponents(petalsJMXClient, jbiDescriptor, prefixLog + "\t");
            this.info(prefixLog + "Needed components installed.");
            jbiPackageURL = this.uploadJBIArchiveIfNeeded(jbiPackageURL, prefixLog + "\t");
            this.info(prefixLog + "Deploying the service-assembly (" + jbiPackageURL.toExternalForm() + ").");
            result = pdsc.deploy(jbiPackageURL);
            this.info(prefixLog + "The service-assembly (" + serviceAssemblyName + ") is deployed: " + result);
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (DeploymentServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (DeploymentServiceDoesNotExistException e) {
            throw new MojoExecutionException("Unable to find the deployment service ", (Exception)((Object)e));
        }
    }

    private void installSharedLibrary(JMXClient petalsJMXClient, Jbi jbiDescriptor) throws MojoExecutionException {
        try {
            String sharedLibraryName = this.getSharedLibraryNameFromJBIDescriptor(jbiDescriptor);
            URL jbiPackageURL = new File(this.outputDirectory + File.separator + this.jbiName + ".zip").toURI().toURL();
            this.installSharedLibraryCore(petalsJMXClient, sharedLibraryName, jbiPackageURL, this.force, "");
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
    }

    private void installSharedLibraryCore(JMXClient petalsJMXClient, String sharedLibraryName, URL jbiPackageURL, boolean forceInstallation, String prefixLog) throws MojoExecutionException {
        try {
            InstallationServiceClient pisc = petalsJMXClient.getInstallationServiceClient();
            String[] installedSharedLibraries = pisc.getInstalledSharedLibraries();
            boolean sharedLibraryFound = false;
            for (int i = 0; i < installedSharedLibraries.length; ++i) {
                if (!sharedLibraryName.equals(installedSharedLibraries[i])) continue;
                this.info(prefixLog + "The shared-library is already installed.");
                sharedLibraryFound = true;
                break;
            }
            if (!forceInstallation && sharedLibraryFound) {
                throw new MojoExecutionException("The shared-library is already installed");
            }
            if (!sharedLibraryFound) {
                this.info(prefixLog + "Shared-library uninstalled.");
            }
            if (forceInstallation && sharedLibraryFound) {
                this.info(prefixLog + "The force mode is asked.");
                this.checkAndShutdownComponents(petalsJMXClient, pisc, sharedLibraryName, prefixLog + "\t");
                this.info(prefixLog + "Uninstalling the shared-library (" + sharedLibraryName + ").");
                if (pisc.uninstallSharedLibrary(sharedLibraryName)) {
                    this.info(prefixLog + "Shared-library uninstalled.");
                } else {
                    throw new MojoExecutionException("Problem during uninstallation. Check server logs.");
                }
            }
            jbiPackageURL = this.uploadJBIArchiveIfNeeded(jbiPackageURL, prefixLog + "\t");
            this.info(prefixLog + "Installing the shared-library (" + jbiPackageURL.toExternalForm() + ").");
            String slName = pisc.installSharedLibrary(jbiPackageURL);
            this.info(prefixLog + "The shared-library (" + slName + ") is installed.");
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (InstallationServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (InstallationServiceDoesNotExistException e) {
            throw new MojoExecutionException("Unable to find the installation service ", (Exception)((Object)e));
        }
    }

    private void checkAndShutdownComponents(JMXClient petalsJMXClient, InstallationServiceClient pisc, String sharedLibraryName, String prefixLog) throws MojoExecutionException {
        try {
            String[] components = pisc.getInstalledComponentsForSharedlibrary(sharedLibraryName);
            for (int i = 0; i < components.length; ++i) {
                this.info(prefixLog + "Checking " + components[i] + " ...");
                try {
                    ComponentClient pccc = petalsJMXClient.getComponentClient(components[i]);
                    this.info(prefixLog + components[i] + " installed.");
                    String componentState = pccc.getState();
                    if ("Started".equals(componentState) || "Stopped".equals(componentState)) {
                        this.info(prefixLog + components[i] + " is in state: " + componentState);
                        this.info(prefixLog + "Shutdowning it ...");
                        pccc.shutdown();
                        this.info(prefixLog + components[i] + " shutdowned.");
                    }
                }
                catch (ComponentDoesNotExistException e) {
                    this.info(prefixLog + components[i] + " not installed.");
                }
                this.info(prefixLog + components[i] + " checked.");
            }
        }
        catch (ComponentErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (InstallationServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }

    private void checkAndStartComponents(JMXClient petalsJMXClient, Jbi jbiDescriptor, String prefixLog) throws MojoExecutionException {
        try {
            List<String> usedComponents = this.getComponentsFromServiceAssemblyJBIDescriptor(jbiDescriptor);
            for (String usedComponent : usedComponents) {
                ComponentClient pccc = null;
                try {
                    this.info(prefixLog + "Checking " + usedComponent + " ...");
                    pccc = petalsJMXClient.getComponentClient(usedComponent);
                    this.info(prefixLog + usedComponent + " installed.");
                }
                catch (ComponentDoesNotExistException e) {
                    this.info(prefixLog + usedComponent + " not installed.");
                    if (this.startMissingComponents.booleanValue()) {
                        pccc = this.installComponentFromMaven(petalsJMXClient, usedComponent, prefixLog + "\t");
                        if (pccc == null) {
                            throw new MojoExecutionException("Unable to install the dependent component.");
                        }
                    }
                    throw new MojoExecutionException("A component (" + usedComponent + ") is missing on the PEtALS server.");
                }
                if (pccc == null) continue;
                if ("Stopped".equals(pccc.getState()) || "Shutdown".equals(pccc.getState()) && this.startMissingComponents.booleanValue()) {
                    this.info(prefixLog + "Starting " + usedComponent + "...");
                    pccc.start();
                    this.info(prefixLog + usedComponent + " started.");
                    continue;
                }
                if ("Started".equals(pccc.getState())) {
                    this.info("The component (" + usedComponent + ") is started on the PEtALS server.");
                    continue;
                }
                throw new MojoExecutionException("The component (" + usedComponent + ") is in the state \"" + pccc.getState() + "\" on the PEtALS server.");
            }
        }
        catch (ComponentErrorException e) {
            throw new MojoExecutionException("Error:", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error:", (Exception)((Object)e));
        }
    }

    private void checkAndInstallSharedLibraries(JMXClient petalsJMXClient, Jbi jbiDescriptor, String prefixLog) throws MojoExecutionException {
        try {
            InstallationServiceClient pisc = petalsJMXClient.getInstallationServiceClient();
            this.info(prefixLog + "Getting installed and needed shared-libraries ...");
            String[] installedSharedLibraries = pisc.getInstalledSharedLibraries();
            List<String> neededSharedLibraries = this.getSharedLibrariesFromComponentJBIDescriptor(jbiDescriptor);
            this.info(prefixLog + "Installed and needed shared-libraries retrieved.");
            for (String neededSharedLibrary : neededSharedLibraries) {
                boolean neededSharedLibraryInstalled = false;
                this.info(prefixLog + "Checking the needed shared-library " + neededSharedLibrary + " ...");
                for (int i = 0; i < installedSharedLibraries.length; ++i) {
                    if (!neededSharedLibrary.equals(installedSharedLibraries[i])) continue;
                    neededSharedLibraryInstalled = true;
                    break;
                }
                if (neededSharedLibraryInstalled) {
                    this.info(prefixLog + "The shared-library " + neededSharedLibrary + " is installed.");
                    continue;
                }
                this.info(prefixLog + "The shared-library " + neededSharedLibrary + " is not installed.");
                if (this.installMissingSharedLibraries.booleanValue()) {
                    if ("jbi-component".equals(this.project.getArtifact().getType())) {
                        this.installSharedLibraryFromMaven(petalsJMXClient, neededSharedLibrary, this.project, prefixLog + "\t");
                        continue;
                    }
                    this.installSharedLibraryFromMaven(petalsJMXClient, neededSharedLibrary, this.getComponentProjectFromSAProject(this.project, jbiDescriptor.getComponent().getIdentification().getName(), prefixLog), prefixLog + "\t");
                    continue;
                }
                throw new MojoExecutionException("A shared-libarry (" + neededSharedLibrary + ") is missing on the PEtALS server.");
            }
        }
        catch (InstallationServiceDoesNotExistException e) {
            throw new MojoExecutionException("Unable to find the installation service ", (Exception)((Object)e));
        }
        catch (InstallationServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error:", (Exception)((Object)e));
        }
    }

    private MavenProject getComponentProjectFromSAProject(MavenProject saProject, String componentName, String prefixLog) throws MojoExecutionException {
        try {
            MavenProject componentProject = null;
            List serviceAssemblyDependencies = saProject.getDependencies();
            for (Dependency serviceAssemblyDependency : serviceAssemblyDependencies) {
                this.debug(prefixLog + "service-assembly dependency: " + serviceAssemblyDependency.getGroupId() + ":" + serviceAssemblyDependency.getArtifactId());
                if (!"jbi-service-unit".equals(serviceAssemblyDependency.getType())) continue;
                Artifact serviceUnitArtifact = this.createDependencyArtifact(serviceAssemblyDependency);
                MavenProject serviceUnitProject = this.buildProjectFromArtifact(serviceUnitArtifact);
                List serviceUnitDependencies = serviceUnitProject.getDependencies();
                for (Dependency serviceUnitDependency : serviceUnitDependencies) {
                    this.debug(prefixLog + "service-unit dependency: " + serviceUnitDependency.getGroupId() + ":" + serviceUnitDependency.getArtifactId());
                    if (!"jbi-component".equals(serviceUnitDependency.getType())) continue;
                    Artifact componentArtifact = this.createDependencyArtifact(serviceUnitDependency);
                    this.artifactResolver.resolve(componentArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    Jbi jbiComponentDescriptor = this.readJbiDescriptor(componentArtifact);
                    Component componentDescription = jbiComponentDescriptor.getComponent();
                    if (!componentName.equals(componentDescription.getIdentification().getName())) continue;
                    componentProject = this.mavenProjectBuilder.buildFromRepository(componentArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    break;
                }
                if (componentProject == null) continue;
                break;
            }
            if (componentProject == null) {
                throw new MojoExecutionException("Component maven project not found.");
            }
            return componentProject;
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
    }

    private ComponentClient installComponentFromMaven(JMXClient petalsJMXClient, String componentName, String prefixLog) throws MojoExecutionException {
        try {
            ComponentClient pccc = null;
            this.info(prefixLog + "Installing " + componentName + " from a Maven repository...");
            boolean serviceUnitFoundInDependencies = false;
            List serviceAssemblyDependencies = this.project.getDependencies();
            boolean componentFoundInAllSUDependencies = false;
            for (Dependency serviceAssemblyDependency : serviceAssemblyDependencies) {
                this.debug(prefixLog + "service-assembly dependency: " + serviceAssemblyDependency.getGroupId() + ":" + serviceAssemblyDependency.getArtifactId() + ":" + serviceAssemblyDependency.getVersion());
                if (!"jbi-service-unit".equals(serviceAssemblyDependency.getType())) continue;
                serviceUnitFoundInDependencies = true;
                Artifact serviceUnitArtifact = this.createDependencyArtifact(serviceAssemblyDependency);
                MavenProject serviceUnitProject = this.buildProjectFromArtifact(serviceUnitArtifact);
                boolean componentFoundInSUDependencies = false;
                List serviceUnitDependencies = serviceUnitProject.getDependencies();
                for (Dependency serviceUnitDependency : serviceUnitDependencies) {
                    this.debug(prefixLog + "service-unit dependency: " + serviceUnitDependency.getGroupId() + ":" + serviceUnitDependency.getArtifactId());
                    if (!"jbi-component".equals(serviceUnitDependency.getType())) continue;
                    Artifact componentArtifact = this.createDependencyArtifact(serviceUnitDependency);
                    componentFoundInSUDependencies = true;
                    this.artifactResolver.resolve(componentArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    Jbi jbiComponentDescriptor = this.readJbiDescriptor(componentArtifact);
                    Component componentDescription = jbiComponentDescriptor.getComponent();
                    this.debug(prefixLog + "Found component named '" + componentDescription.getIdentification().getName() + "', expected one is " + componentName);
                    if (componentName.equals(componentDescription.getIdentification().getName())) {
                        componentFoundInAllSUDependencies = true;
                        this.installComponentCore(petalsJMXClient, jbiComponentDescriptor, componentArtifact.getFile().toURI().toURL(), prefixLog + "\t");
                        this.info(prefixLog + componentName + " installed.");
                        pccc = petalsJMXClient.getComponentClient(componentName);
                        continue;
                    }
                    this.info(prefixLog + componentDescription.getIdentification().getName() + " found but not needed -> not installed.");
                }
                if (componentFoundInSUDependencies) continue;
                throw new MojoExecutionException("No JBI component declared in the POM of the service-unit " + serviceUnitArtifact.getGroupId() + ":" + serviceUnitArtifact.getArtifactId() + ".");
            }
            if (!componentFoundInAllSUDependencies) {
                throw new MojoExecutionException("The required component has not been found in all the service-assembly dependencies.");
            }
            if (!serviceUnitFoundInDependencies) {
                throw new MojoExecutionException("No service-units declared in this service-assembly.");
            }
            this.info(prefixLog + componentName + " installed from a Maven repository...");
            return pccc;
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Unbale to retrieve the JMX component associated to the JBI component", (Exception)((Object)e));
        }
        catch (ComponentErrorException e) {
            throw new MojoExecutionException("Unbale to retrieve the JMX component associated to the JBI component", (Exception)((Object)e));
        }
        catch (ComponentDoesNotExistException e) {
            throw new MojoExecutionException("Unbale to retrieve the JMX component associated to the JBI component", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error during the artifact resolution.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Artifact not found.", (Exception)((Object)e));
        }
    }

    private void installSharedLibraryFromMaven(JMXClient petalsJMXClient, String sharedLibraryName, MavenProject mvnProject, String prefixLog) throws MojoExecutionException {
        try {
            this.info(prefixLog + "Installing " + sharedLibraryName + " from a Maven repository...");
            boolean sharedLibraryInstalled = false;
            boolean foundInDependencies = false;
            List dependencies = mvnProject.getDependencies();
            for (Dependency dependency : dependencies) {
                if (!"jbi-shared-library".equals(dependency.getType())) continue;
                foundInDependencies = true;
                try {
                    Artifact artifact = this.createDependencyArtifact(dependency);
                    this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    Jbi jbiComponentDescriptor = this.readJbiDescriptor(artifact);
                    Jbi.SharedLibrary sharedLibrary = jbiComponentDescriptor.getSharedLibrary();
                    if (!sharedLibraryName.equals(sharedLibrary.getIdentification().getName())) continue;
                    this.installSharedLibraryCore(petalsJMXClient, sharedLibraryName, artifact.getFile().toURI().toURL(), false, prefixLog);
                    sharedLibraryInstalled = true;
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
                }
                catch (ArtifactResolutionException e) {
                    this.error(prefixLog + "Error during the artifact resolution.", e);
                }
                catch (ArtifactNotFoundException e) {
                    this.error(prefixLog + "Artifact not found.");
                }
            }
            if (!foundInDependencies) {
                this.info(prefixLog + sharedLibraryName + " not found in dependencies.");
            }
            if (sharedLibraryInstalled) {
                this.info(prefixLog + sharedLibraryName + " installed.");
            } else {
                this.info(prefixLog + sharedLibraryName + " not installed.");
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
    }

    private void uploadArchive(File jbiArchive, String prefixLog) throws MojoExecutionException {
        Wagon wagon = null;
        try {
            String url = this.protocol + "://" + this.host + this.remoteDirectory;
            this.debug(prefixLog + "uploading URL: " + url);
            Repository repository = new Repository(this.serverId, url);
            wagon = this.wagonManager.getWagon(repository);
            try {
                Debug debug = new Debug();
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
                wagon.connect(repository, this.wagonManager.getAuthenticationInfo(this.serverId));
                wagon.put(jbiArchive, jbiArchive.getName());
            }
            catch (ConnectionException e) {
                throw new MojoExecutionException("Error connecting to the Petals server", (Exception)((Object)e));
            }
            catch (AuthenticationException e) {
                throw new MojoExecutionException("Error authenticating on the Petals server", (Exception)((Object)e));
            }
            catch (TransferFailedException e) {
                throw new MojoExecutionException("Error transfering the JBI archive", (Exception)((Object)e));
            }
            catch (AuthorizationException e) {
                throw new MojoExecutionException("Not authorized to upload in the remote directory.", (Exception)((Object)e));
            }
            catch (ResourceDoesNotExistException e) {
                throw new MojoExecutionException("Error uploading", (Exception)((Object)e));
            }
            finally {
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                }
            }
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + this.protocol + "'", (Exception)((Object)e));
        }
        catch (WagonConfigurationException e) {
            throw new MojoExecutionException("Misconfigured protocol: '" + this.protocol + "'", (Exception)((Object)e));
        }
    }

    private URL uploadJBIArchiveIfNeeded(URL jbiArchiveURL, String prefixLog) throws MojoExecutionException {
        URL newJBIArchiveURL = null;
        try {
            InetAddress localIp = InetAddress.getLocalHost();
            InetAddress petalsServerIp = InetAddress.getByName(this.host);
            if (!localIp.equals(petalsServerIp)) {
                this.info(prefixLog + "The JBI archive will be uploaded on the Petals server.");
                this.debug(prefixLog + "source JBI archive URL: " + jbiArchiveURL);
                File fileToUpload = new File(jbiArchiveURL.toURI());
                this.uploadArchive(fileToUpload, prefixLog);
                newJBIArchiveURL = new URL("file", null, this.remoteDirectory + "/" + new File(jbiArchiveURL.toURI()).getName());
                this.debug(prefixLog + "remote JBI archive URL: " + newJBIArchiveURL);
            } else {
                newJBIArchiveURL = jbiArchiveURL;
            }
            return newJBIArchiveURL;
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Networking error", (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("URI error", (Exception)e);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL for JBI archive location", (Exception)e);
        }
    }

    private void checkAndUndeployServiceAssemblies(JMXClient petalsJMXClient, String componentName, String prefixLog) throws MojoExecutionException {
        try {
            DeploymentServiceClient pdsc = petalsJMXClient.getDeploymentServiceClient();
            String[] serviceAssemblies = pdsc.getDeployedServiceAssembliesForComponent(componentName);
            for (int i = 0; i < serviceAssemblies.length; ++i) {
                this.info(prefixLog + "Undeploying the service-assembly: " + serviceAssemblies[i] + " ...");
                pdsc.undeploy(serviceAssemblies[i]);
                this.info(prefixLog + "service-assembly undeployed: " + prefixLog);
            }
        }
        catch (DeploymentServiceErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        catch (DeploymentServiceDoesNotExistException e) {
            throw new MojoExecutionException("Unable to find the deployment service ", (Exception)((Object)e));
        }
        catch (ConnectionErrorException e) {
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
    }
}

